package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class ValidateCruiseUI extends JSplitPane implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<ValidateCruiseUIModel, ValidateCruiseUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EXPORT_OPERATION_MESSAGES_ITEM_ENABLED = "exportOperationMessagesItem.enabled";
    public static final String BINDING_READY_TO_SYNCH_BUTTON_ENABLED = "readyToSynchButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1WTW8bRRieuLET56OFhIRAipSEIjUSTECAKCS0+YBQRzGNareKyKGMdyf2pOOd6cxsulEUxE/gJ8CdCxI3TogDZw5cEH8BoR64It7ZXe960zV2Eikre/Z9n/d93o9n/P1fqKgVWjwiQYCV7xnWpnhnY3//XuOIOuYTqh3FpBEKRX9DBVQ4QONucq4Nev1g17qvxO4rW6IthUe9Lu/VXTSmzQmnukWpMei1rIej9Uoteb0aSF91UJOk8lC/ffZ34Rv36+8KCAUSspsEKgv9vFImw7uowFyDpiDSMVnhxGtCGop5Tch30p5tcaL156RNn6Cv0MguKkmiAMygpcEphxihfyANKmvJmdkjHjXow0OF2aGibaqw8Y1h2GdYP4X42BGeATjsKJ9pih8Szlxi6Fb49UFFyhCxZFCxLVzKDbp9aayqBUgBSw0lHlNl0HJvxLr9ehe8NkPb1HnGI8esSQwTXp0ZTl1LFLJbFKqJj2BqHhshI5AA7+x32ViAcoIzBmZ1IfgmgUResp0I4tA78bE1nErsJ2gghTKbkBeQRdMZj+jUWs4kDuU29fw9IX1oyWzGOjyswtuU1XyEfk9SFVKrUq1Jk+qKoW3gnHG3nvbcus4nCKM3dkKWb8OwZaN1uKdcrqU1jKv3csal5ijBuX1lHRbTmqV+Br2YrZmiofGNxHhKUeKe1EXtxHNaaYFezUJeFR3KcSZ3+k9Z4oK3mW7Bm6Rs+kEl7rJC85kthf3H6f6nCzp0gIrKh2OD5g6el4z78CoSi7lzYmEBw7f/zk7//tOfP253FGIUYs/kmnYJHGyuVJaHYTb0tUgefMP4SpXI1QNYYspBHUP1u56TWC1+DclBvLAX2Lrju0S3AKI48sfPv8x++dsVVNhGY1wQd5tY+woqm5aCKgjuBvLOepjRxNNReL4A/1dg3Y1dGYPeiKp/nNllnE4Aju1KDaFcu82lU8/n/AzYKNZsgU45QsWzMnGabttZANW8nlPNhFKj/Os/07Uf1jsVHQKGr/Q0T6ta/AKVmMeZR0PVjQU1V2XHpaa+K1LhzJNS1EttZLy474XPW3lVLB9CzQ1p2AoVDwnXtlJCkid+18FkVLo9wmCw3c554FvU9ZC4/bSJMmrVL/gwWEOrIeOKXRhUiqQFFvIRkXAzOCGbDSfqTPW0975FKPjT0D/qf6zsXQoVAWHH1g16P24gyzqTdRpAyPf7zVAcIkoRE85hqkAvi49aUGWDPjpdujiCdV06y6tiRsP71XHEoBHq2Q5CZ+ZOw0sQM32/S9VuLgPjYRNSfXfARLtV8Vynhu1s9+jTZ/37VCPHcdi66M7yXIcm2Du3vKpH28JjjkFrl8gbtxP3bL8/uAxYpuNrA3c8g9G75znXUL/OD0E6nDTsbfRmlAx1mdlwHObC9UNgCU2YNugBbtjPUYV1Xvj0V8CF5u2teN6a1EQ6R93zd93N5YXFjxdiyY2HcND6x9uSXKQXkoy9QSUjSbWvapybyfVL0ug5l6uXBczM5vpF1SjF6T2f//fLb4BBHVdCmIdMs66bJvcCSZMcALXEyYkAqujqGvAkCw3mudDe288hD9nnEiD+B0Q+1qPmDQAA";
    private static final Log log = LogFactory.getLog(ValidateCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton exportButton;
    protected JMenuItem exportOperationMessagesItem;
    protected final ValidateCruiseUIHandler handler = new ValidateCruiseUIHandler();
    protected JPopupMenu menuPopup;
    protected ValidateCruiseUIModel model;
    protected JTree navigation;
    protected JScrollPane navigationPanel;
    protected JXTitledPanel navigationTitledPanel;
    protected FishingOperationsUI operationPanel;
    protected JButton readyToSynchButton;
    protected ValidateCruiseUI splitPane = this;
    protected JToolBar topToolBar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ValidateCruiseUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public ValidateCruiseUI(int param0) {
        super(param0);
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext, int param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidateCruiseUI(int param0, Component param1, Component param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext, int param1, Component param2, Component param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidateCruiseUI(int param0, boolean param1, Component param2, Component param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext, int param1, boolean param2, Component param3, Component param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidateCruiseUI(int param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext, int param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidateCruiseUI() {
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyPressed__on__navigation(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openNodeMenu(event, menuPopup);
    }

    public void doMouseClicked__on__navigation(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectNode(event, menuPopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getExportButton() {
        return exportButton;
    }

    public JMenuItem getExportOperationMessagesItem() {
        return exportOperationMessagesItem;
    }

    public ValidateCruiseUIHandler getHandler() {
        return handler;
    }

    public JPopupMenu getMenuPopup() {
        return menuPopup;
    }

    public ValidateCruiseUIModel getModel() {
        return model;
    }

    public JTree getNavigation() {
        return navigation;
    }

    public JScrollPane getNavigationPanel() {
        return navigationPanel;
    }

    public JXTitledPanel getNavigationTitledPanel() {
        return navigationTitledPanel;
    }

    public FishingOperationsUI getOperationPanel() {
        return operationPanel;
    }

    public JButton getReadyToSynchButton() {
        return readyToSynchButton;
    }

    public JToolBar getTopToolBar() {
        return topToolBar;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMenuPopup() {
        if (!allComponentsCreated) {
            return;
        }
        menuPopup.add(exportOperationMessagesItem);
    }

    protected void addChildrenToNavigationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        navigationPanel.getViewport().add(navigation);
    }

    protected void addChildrenToNavigationTitledPanel() {
        if (!allComponentsCreated) {
            return;
        }
        navigationTitledPanel.add(topToolBar);
        navigationTitledPanel.add($JPanel0);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        add(navigationTitledPanel, JSplitPane.LEFT);
        add(operationPanel, JSplitPane.RIGHT);
    }

    protected void addChildrenToTopToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        topToolBar.add(exportButton);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.validateCruise.help"));
    }

    protected void createExportButton() {
        $objectMap.put("exportButton", exportButton = new JButton());
        
        exportButton.setName("exportButton");
        exportButton.setToolTipText(t("tutti.validateCruise.navigation.action.export.all.tip"));
        exportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportCruiseValidationMessagesAction.class);
        exportButton.putClientProperty("help", "tutti.validateCruise.navigation.action.export.all.help");
    }

    protected void createExportOperationMessagesItem() {
        $objectMap.put("exportOperationMessagesItem", exportOperationMessagesItem = new JMenuItem());
        
        exportOperationMessagesItem.setName("exportOperationMessagesItem");
        exportOperationMessagesItem.setText(t("tutti.validateCruise.navigation.action.export.operation"));
        exportOperationMessagesItem.setToolTipText(t("tutti.validateCruise.navigation.action.export.operation.tip"));
        exportOperationMessagesItem.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportOperationValidationMessagesAction.class);
        exportOperationMessagesItem.putClientProperty("help", "tutti.validateCruise.navigation.action.export.operation.help");
    }

    protected void createMenuPopup() {
        $objectMap.put("menuPopup", menuPopup = new JPopupMenu());
        
        menuPopup.setName("menuPopup");
        menuPopup.setLabel("tutti.editAccidentalBatch.title.batchActions");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ValidateCruiseUIModel.class));
    }

    protected void createNavigation() {
        $objectMap.put("navigation", navigation = new JTree());
        
        navigation.setName("navigation");
        navigation.setRootVisible(false);
        navigation.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__navigation"));
        navigation.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__navigation"));
    }

    protected void createNavigationPanel() {
        $objectMap.put("navigationPanel", navigationPanel = new JScrollPane());
        
        navigationPanel.setName("navigationPanel");
    }

    protected void createNavigationTitledPanel() {
        $objectMap.put("navigationTitledPanel", navigationTitledPanel = new JXTitledPanel());
        
        navigationTitledPanel.setName("navigationTitledPanel");
        navigationTitledPanel.setTitle(t("tutti.validateCruise.navigation.title"));
    }

    protected void createOperationPanel() {
        $objectMap.put("operationPanel", operationPanel = new FishingOperationsUI(this));
        
        operationPanel.setName("operationPanel");
    }

    protected void createReadyToSynchButton() {
        $objectMap.put("readyToSynchButton", readyToSynchButton = new JButton());
        
        readyToSynchButton.setName("readyToSynchButton");
        readyToSynchButton.setText(t("tutti.validateCruise.navigation.action.readyToSynch"));
        readyToSynchButton.setToolTipText(t("tutti.validateCruise.navigation.action.readyToSynch.tip"));
        readyToSynchButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SaveCruiseToReadyToSynchAction.class);
        readyToSynchButton.putClientProperty("help", "tutti.validateCruise.navigation.action.readyToSynch.help");
    }

    protected void createTopToolBar() {
        $objectMap.put("topToolBar", topToolBar = new JToolBar());
        
        topToolBar.setName("topToolBar");
        topToolBar.setFloatable(false);
        topToolBar.setOpaque(false);
        topToolBar.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSplitPane();
        addChildrenToNavigationTitledPanel();
        addChildrenToTopToolBar();
        addChildrenToMenuPopup();
        // inline complete setup of $JPanel0
        $JPanel0.add(navigationPanel, BorderLayout.CENTER);
        $JPanel0.add(readyToSynchButton, BorderLayout.SOUTH);
        addChildrenToNavigationPanel();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        navigationTitledPanel.setBorder(null);
        navigationTitledPanel.setRightDecoration(topToolBar);
        exportButton.setIcon(SwingUtil.createActionIcon("export"));
        exportOperationMessagesItem.setIcon(SwingUtil.createActionIcon("export"));
        exportOperationMessagesItem.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.validateCruise.navigation.action.export.operation.mnemonic"),'Z'));
        readyToSynchButton.setIcon(SwingUtil.createActionIcon("time"));
        readyToSynchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.validateCruise.navigation.action.readyToSynch.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, exportButton, "tutti.validateCruise.navigation.action.export.all.help");
        registerHelpId(_broker, exportOperationMessagesItem, "tutti.validateCruise.navigation.action.export.operation.help");
        registerHelpId(_broker, readyToSynchButton, "tutti.validateCruise.navigation.action.readyToSynch.help");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("splitPane", splitPane);
        createModel();
        createBroker();
        createNavigationTitledPanel();
        createTopToolBar();
        createExportButton();
        createMenuPopup();
        createExportOperationMessagesItem();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createNavigationPanel();
        createNavigation();
        createReadyToSynchButton();
        createOperationPanel();
        // inline creation of splitPane
        setName("splitPane");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_OPERATION_MESSAGES_ITEM_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportOperationMessagesItem.setEnabled(model.getSelectedFishingOperation() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_READY_TO_SYNCH_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readyToSynch", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    readyToSynchButton.setEnabled(model.isReadyToSynch());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readyToSynch", this);
                }
            }
        });
    }

}