/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.i18n.ThreadResources;

public class ResourceHelper {
    protected String baseName = null;

    ResourceHelper(String baseName) {
        this.baseName = baseName;
    }

    public static ResourceHelper getHelper(String baseName) {
        return new ResourceHelper(baseName);
    }

    public List<String> getMessageFilenames(ULocale locale) {
        return this.getMessageFilenames(locale, true);
    }

    public List<String> getMessageFilenames(ULocale locale, boolean appendDefault) {
        StringBuffer temp;
        if (locale == null) {
            locale = ThreadResources.getLocale();
        }
        ArrayList<String> bundleNames = new ArrayList<String>();
        if (this.baseName == null) {
            return bundleNames;
        }
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        if (languageLength > 0 && countryLength > 0) {
            temp = new StringBuffer(this.baseName);
            temp.append("_");
            temp.append(language);
            temp.append("_");
            temp.append(country);
            StringBuffer variantTmp = new StringBuffer(temp.toString());
            if (variantLength > 0) {
                variantTmp.append("_");
                variantTmp.append(variant);
                variantTmp.append(".properties");
                bundleNames.add(variantTmp.toString());
            }
            temp.append(".properties");
            bundleNames.add(temp.toString());
        }
        if (languageLength > 0) {
            temp = new StringBuffer(this.baseName);
            temp.append("_");
            temp.append(language);
            temp.append(".properties");
            bundleNames.add(temp.toString());
        }
        if (appendDefault) {
            bundleNames.add(String.valueOf(this.baseName) + ".properties");
        }
        return bundleNames;
    }
}

