/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.util.List;
import liquibase.Liquibase;
import liquibase.integration.ant.BaseLiquibaseTask;
import liquibase.util.StringUtils;
import org.apache.tools.ant.BuildException;

public class DropAllTask
extends BaseLiquibaseTask {
    private String schemas;

    public String getSchemas() {
        return this.schemas;
    }

    public void setSchemas(String schemas) {
        this.schemas = schemas;
    }

    public void execute() throws BuildException {
        super.execute();
        if (!this.shouldRun()) {
            return;
        }
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibase();
            if (StringUtils.trimToNull(this.schemas) != null) {
                List<String> schemas = StringUtils.splitAndTrim(this.schemas, ",");
                liquibase.dropAll(schemas.toArray(new String[schemas.size()]));
            } else {
                liquibase.dropAll();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }
}

