/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.pupitri.PupitriCatch;
import fr.ifremer.tutti.service.pupitri.Signs;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableFloat;

public class PupitriImportResult {
    final File trunkFile;
    final File carrousselFile;
    int nbTrunkImported;
    int nbTrunkNotImported;
    int nbCarrousselImported;
    int nbCarrousselNotImported;
    private float sortedWeight;
    private float rejectedWeight;
    private Float carrouselSortedWeight;
    private final List<PupitriCatch> catches;
    private MutableFloat melagTotalWeight;
    private MutableFloat melagSortedWeight;
    private final Set<Species> melagSpecies;

    public PupitriImportResult(File trunkFile, File carrousselFile) {
        this.trunkFile = trunkFile;
        this.carrousselFile = carrousselFile;
        this.catches = new ArrayList<PupitriCatch>();
        this.melagSpecies = new HashSet<Species>();
    }

    public boolean isFishingOperationFound() {
        return this.nbTrunkImported + this.nbCarrousselImported > 0;
    }

    public File getTrunkFile() {
        return this.trunkFile;
    }

    public File getCarrousselFile() {
        return this.carrousselFile;
    }

    public int getNbTrunkImported() {
        return this.nbTrunkImported;
    }

    public int getNbTrunkNotImported() {
        return this.nbTrunkNotImported;
    }

    public int getNbCarrousselImported() {
        return this.nbCarrousselImported;
    }

    public int getNbCarrousselNotImported() {
        return this.nbCarrousselNotImported;
    }

    public float getSortedWeight() {
        return this.sortedWeight;
    }

    public float getRejectedWeight() {
        return this.rejectedWeight;
    }

    public Float getCarrouselSortedWeight() {
        return this.carrouselSortedWeight;
    }

    public List<PupitriCatch> getCatches() {
        return this.catches;
    }

    public Float getMelagTotalWeight() {
        return this.melagTotalWeight == null ? null : Float.valueOf(this.melagTotalWeight.floatValue());
    }

    public Float getMelagSortedWeight() {
        return this.melagSortedWeight == null ? null : Float.valueOf(this.melagSortedWeight.floatValue());
    }

    public Set<Species> getMelagSpecies() {
        return this.melagSpecies;
    }

    public boolean isFoundTotalMelag() {
        return this.melagTotalWeight != null;
    }

    public boolean isFoundSortedMelag() {
        return this.melagSortedWeight != null;
    }

    void incrementNbTrunkImported() {
        ++this.nbTrunkImported;
    }

    void incrementNbTrunkNotImported() {
        ++this.nbTrunkNotImported;
    }

    void incrementNbCarrousselImported() {
        ++this.nbCarrousselImported;
    }

    void incrementNbCarrousselNotImported() {
        ++this.nbCarrousselNotImported;
    }

    void setNbCarrousselNotImported(int nbCarrousselNotImported) {
        this.nbCarrousselNotImported = nbCarrousselNotImported;
    }

    void setSortedWeight(float sortedWeight) {
        this.sortedWeight = sortedWeight;
    }

    void setRejectedWeight(float rejectedWeight) {
        this.rejectedWeight = rejectedWeight;
    }

    void setCarrouselSortedWeight(Float carrouselSortedWeight) {
        this.carrouselSortedWeight = carrouselSortedWeight;
    }

    void setCatches(List<PupitriCatch> catches) {
        for (PupitriCatch aCatch : catches) {
            this.addCatch(aCatch);
        }
    }

    void addCatch(PupitriCatch aCatch) {
        this.catches.add(aCatch);
        if (aCatch.isMelagMetaSpecies()) {
            this.addMelagTotalWeight(aCatch.getWeight(Signs.DEFAULT).floatValue());
        }
        if (aCatch.isForMelag()) {
            this.melagSpecies.add(aCatch.getSpecies());
            this.addMelagSortedWeight(aCatch.getWeight(Signs.MELAG).floatValue());
        }
    }

    void addMelagTotalWeight(float weight) {
        if (this.melagTotalWeight == null) {
            this.melagTotalWeight = new MutableFloat();
        }
        this.melagTotalWeight.add(weight);
    }

    void addMelagSortedWeight(float weight) {
        if (this.melagSortedWeight == null) {
            this.melagSortedWeight = new MutableFloat();
        }
        this.melagSortedWeight.add(weight);
    }

    void prepareMelag() {
        boolean useMelag = this.isFoundTotalMelag() && this.isFoundSortedMelag();
        float melagRatio = 1.0f;
        if (useMelag) {
            melagRatio = this.melagSortedWeight.floatValue() / this.melagTotalWeight.floatValue();
        }
        Iterator<PupitriCatch> iterator = this.catches.iterator();
        while (iterator.hasNext()) {
            PupitriCatch aCatch = iterator.next();
            if (useMelag && aCatch.isMelagMetaSpecies()) {
                iterator.remove();
                continue;
            }
            if (!aCatch.isForMelag()) continue;
            if (useMelag) {
                Float sampleWeight = aCatch.getWeight(Signs.MELAG);
                Float weight = Float.valueOf(TuttiEntities.roundKiloGram((float)(sampleWeight.floatValue() / melagRatio)));
                aCatch.addToSign(Signs.DEFAULT, weight);
                aCatch.removeSign(Signs.MELAG);
                continue;
            }
            Float weight = aCatch.getWeight(Signs.MELAG);
            aCatch.addToSign(Signs.DEFAULT, weight);
            aCatch.removeSign(Signs.MELAG);
        }
    }
}

