/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IDrillThroughAction;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.impl.DrillThroughAction;

public class ActionContent
implements IHyperlinkAction {
    protected int type = -1;
    protected String bookmark;
    protected String hyperlink;
    protected String tooltip;
    protected String target = null;
    protected IDrillThroughAction drillThrough;
    protected static final int VERSION = 0;
    static final int FIELD_NONE = -1;
    static final int FIELD_TYPE = 0;
    static final int FIELD_BOOKMARK = 1;
    static final int FIELD_HYPERLINK = 2;
    static final int FIELD_REPORTNAME = 3;
    static final int FIELD_PARAMETERBINDINGS = 4;
    static final int FIELD_SEARCHCRITERIA = 5;
    static final int FIELD_TARGET = 6;
    static final int FIELD_FORMAT = 7;
    static final int FIELD_ISBOOKMARK = 8;
    static final int FIELD_TARGETFILETYPE = 9;
    static final int FIELD_TOOLTIP = 10;

    @Override
    public void setHyperlink(String hyperlink, String target) {
        this.type = 1;
        this.hyperlink = hyperlink;
        this.target = target;
    }

    @Override
    public void setBookmark(String bookmark) {
        this.type = 2;
        this.bookmark = bookmark;
    }

    @Override
    public void setDrillThrough(String bookmark, boolean isBookmark, String reportName, Map parameterBindings, Map searchCriteria, String target, String format) {
        this.setDrillThrough(bookmark, isBookmark, reportName, parameterBindings, searchCriteria, target, format, (String)null);
    }

    public void setDrillThrough(String bookmark, boolean isBookmark, String reportName, Map parameterBindings, Map searchCriteria, String target, String format, String targetFileType) {
        this.type = 3;
        this.drillThrough = new DrillThroughAction(bookmark, isBookmark, reportName, parameterBindings, searchCriteria, target, format, targetFileType);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getBookmark() {
        if (this.isDrillThrough()) {
            return this.drillThrough.getBookmark();
        }
        return this.bookmark;
    }

    @Override
    public String getReportName() {
        assert (this.type == 3);
        if (this.isDrillThrough()) {
            return this.drillThrough.getReportName();
        }
        return null;
    }

    @Override
    public void setReportName(String reportName) {
        assert (this.type == 3);
        if (this.isDrillThrough()) {
            this.drillThrough.setReportName(reportName);
        }
    }

    @Override
    public Map getParameterBindings() {
        if (this.isDrillThrough()) {
            return this.drillThrough.getParameterBindings();
        }
        return null;
    }

    @Override
    public Map getSearchCriteria() {
        assert (this.type == 3);
        if (this.isDrillThrough()) {
            return this.drillThrough.getSearchCriteria();
        }
        return null;
    }

    @Override
    public String getTargetWindow() {
        if (this.isDrillThrough()) {
            return this.drillThrough.getTargetWindow();
        }
        return this.target;
    }

    @Override
    public String getHyperlink() {
        return this.hyperlink;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        if (this.type != -1) {
            IOUtil.writeInt(out, 0);
            IOUtil.writeInt(out, this.type);
        }
        if (this.isDrillThrough()) {
            if (this.drillThrough.getBookmark() != null) {
                IOUtil.writeInt(out, 1);
                IOUtil.writeString(out, this.drillThrough.getBookmark());
            }
        } else if (this.bookmark != null) {
            IOUtil.writeInt(out, 1);
            IOUtil.writeString(out, this.bookmark);
        }
        if (this.isDrillThrough() && this.drillThrough.isBookmark()) {
            IOUtil.writeInt(out, 8);
            IOUtil.writeBool(out, this.drillThrough.isBookmark());
        }
        if (this.hyperlink != null) {
            IOUtil.writeInt(out, 2);
            IOUtil.writeString(out, this.hyperlink);
        }
        if (this.isDrillThrough() && this.drillThrough.getReportName() != null) {
            IOUtil.writeInt(out, 3);
            IOUtil.writeString(out, this.drillThrough.getReportName());
        }
        if (this.isDrillThrough() && this.drillThrough.getParameterBindings() != null) {
            IOUtil.writeInt(out, 4);
            IOUtil.writeMap(out, this.drillThrough.getParameterBindings());
        }
        if (this.isDrillThrough() && this.drillThrough.getSearchCriteria() != null) {
            IOUtil.writeInt(out, 5);
            IOUtil.writeMap(out, this.drillThrough.getSearchCriteria());
        }
        if (this.isDrillThrough() && this.drillThrough.getTargetWindow() != null) {
            IOUtil.writeInt(out, 6);
            IOUtil.writeString(out, this.drillThrough.getTargetWindow());
        } else if (this.target != null) {
            IOUtil.writeInt(out, 6);
            IOUtil.writeString(out, this.target);
        }
        if (this.tooltip != null) {
            IOUtil.writeInt(out, 10);
            IOUtil.writeString(out, this.tooltip);
        }
        if (this.isDrillThrough() && this.drillThrough.getFormat() != null) {
            IOUtil.writeInt(out, 7);
            IOUtil.writeString(out, this.drillThrough.getFormat());
        }
        if (this.isDrillThrough() && this.drillThrough.getTargetFileType() != null) {
            IOUtil.writeInt(out, 9);
            IOUtil.writeString(out, this.drillThrough.getTargetFileType());
        }
    }

    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 0: {
                this.type = IOUtil.readInt(in);
                if (this.type != 3) break;
                this.drillThrough = new DrillThroughAction();
                break;
            }
            case 1: {
                String bk = IOUtil.readString(in);
                if (this.isDrillThrough()) {
                    this.drillThrough.setBookmark(bk);
                    break;
                }
                this.bookmark = bk;
                break;
            }
            case 2: {
                this.hyperlink = IOUtil.readString(in);
                break;
            }
            case 3: {
                String name = IOUtil.readString(in);
                if (!this.isDrillThrough()) break;
                this.drillThrough.setReportName(name);
                break;
            }
            case 4: {
                Map bindings = IOUtil.readMap(in, loader);
                if (!this.isDrillThrough()) break;
                this.drillThrough.setParameterBindings(bindings);
                break;
            }
            case 5: {
                Map search = IOUtil.readMap(in, loader);
                if (!this.isDrillThrough()) break;
                this.drillThrough.setSearchCriteria(search);
                break;
            }
            case 6: {
                String tgt = IOUtil.readString(in);
                if (this.isDrillThrough()) {
                    this.drillThrough.setTargetWindow(tgt);
                    break;
                }
                this.target = tgt;
                break;
            }
            case 7: {
                String fmt = IOUtil.readString(in);
                if (!this.isDrillThrough()) break;
                this.drillThrough.setFormat(fmt);
                break;
            }
            case 8: {
                boolean isBk = IOUtil.readBool(in);
                if (!this.isDrillThrough()) break;
                this.drillThrough.setBookmarkType(isBk);
                break;
            }
            case 9: {
                String tgtType = IOUtil.readString(in);
                if (!this.isDrillThrough()) break;
                this.drillThrough.setTargetFileType(tgtType);
                break;
            }
            case 10: {
                this.tooltip = IOUtil.readString(in);
            }
        }
    }

    public void readObject(DataInputStream in, ClassLoader loader) throws IOException {
        int version = IOUtil.readInt(in);
        int filedId = IOUtil.readInt(in);
        while (filedId != -1) {
            this.readField(version, filedId, in, loader);
            filedId = IOUtil.readInt(in);
        }
    }

    public void writeObject(DataOutputStream out) throws IOException {
        IOUtil.writeInt(out, 0);
        this.writeFields(out);
        IOUtil.writeInt(out, -1);
    }

    @Override
    public String getFormat() {
        if (this.isDrillThrough()) {
            return this.drillThrough.getFormat();
        }
        return null;
    }

    @Override
    public void setBookmarkType(boolean isBookmark) {
        if (this.isDrillThrough()) {
            this.drillThrough.setBookmarkType(isBookmark);
        }
    }

    @Override
    public boolean isBookmark() {
        if (this.isDrillThrough()) {
            return this.drillThrough.isBookmark();
        }
        return false;
    }

    @Override
    public IDrillThroughAction getDrillThrough() {
        if (this.isDrillThrough()) {
            return this.drillThrough;
        }
        return null;
    }

    @Override
    public void setDrillThrough(IDrillThroughAction drillThrough) {
        this.type = 3;
        this.drillThrough = drillThrough;
    }

    private boolean isDrillThrough() {
        return this.type == 3;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }
}

