package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: ShowReportAction.java 1388 2013-11-26 08:03:42Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.4.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/ShowReportAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * To show report screen.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.9
 */
public class ShowReportAction extends AbstractChangeScreenAction {

    /** Logger. */
    private static final Log log = LogFactory.getLog(ShowReportAction.class);

    public ShowReportAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.REPORT);
    }

    @Override
    public void doAction() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Show report screen");
        }
        super.doAction();
    }
}
