/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.romdoc;

import java.io.FileNotFoundException;
import org.eclipse.birt.doc.romdoc.DocChoice;
import org.eclipse.birt.doc.romdoc.DocComposite;
import org.eclipse.birt.doc.romdoc.DocElement;
import org.eclipse.birt.doc.romdoc.DocInheritedProperty;
import org.eclipse.birt.doc.romdoc.DocMethod;
import org.eclipse.birt.doc.romdoc.DocProperty;
import org.eclipse.birt.doc.romdoc.DocSlot;
import org.eclipse.birt.doc.romdoc.Generator;
import org.eclipse.birt.doc.util.HtmlDocReader;

public class DocParser
extends HtmlDocReader {
    Generator generator;
    DocComposite docObj;

    public DocParser(Generator gen) {
        this.generator = gen;
    }

    public DocElement getElement() {
        return (DocElement)this.docObj;
    }

    public void parse(DocComposite e) throws ParseException {
        this.docObj = e;
        String dir = e.isElement() ? "element" : "struct";
        String templateDir = this.generator.templateDir;
        String fileName = String.valueOf(templateDir) + "/" + dir + "s/" + this.docObj.getName() + ".html";
        try {
            this.parser.open(fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("No documentation file for " + dir + " " + this.docObj.getName());
            return;
        }
        this.parseElement();
        this.parseMembers();
    }

    private void parseElement() throws ParseException {
        this.skipTo("/h1");
        this.docObj.setSummary(this.stripPara(this.copySection()));
        int token;
        while ((token = this.getToken()) != -1) {
            if (this.isElement(token, "h2") || this.isElement(token, "/body") || this.isElement(token, "/html")) {
                this.pushToken(token);
                return;
            }
            assert (this.isElement(token, "h3"));
            token = this.getToken();
            if (this.isElement(token, "/h3")) {
                this.warning("Blank section header");
            } else if (token != 1) {
                String msg = "Unexpected element inside section header";
                this.error(msg);
                throw new ParseException(msg);
            }
            String header = this.parser.getTokenText();
            token = this.getToken();
            if (!this.isElement(token, "/h3")) {
                this.pushToken(token);
            }
            if (header.equalsIgnoreCase("Description")) {
                this.docObj.setDescription(this.copySection());
                continue;
            }
            if (header.equalsIgnoreCase("XML Summary")) {
                if (!this.docObj.isElement()) continue;
                this.getElement().setXmlSummary(this.copySection());
                continue;
            }
            if (header.equalsIgnoreCase("See Also")) {
                this.docObj.setSeeAlso(this.copySection());
                continue;
            }
            if (header.equalsIgnoreCase("Inherited Properties")) {
                if (this.docObj.isElement()) {
                    this.parseInheritedProperties();
                    continue;
                }
                this.copySection();
                continue;
            }
            if (header.equalsIgnoreCase("Issues")) {
                this.copySection();
                continue;
            }
            this.warning("Unexpected Element header: " + header);
            this.copySection();
        }
        return;
    }

    private void parseInheritedProperties() throws ParseException {
        int token;
        do {
            if (!this.isBlockEnd(token = this.getToken())) continue;
            this.pushToken(token);
            return;
        } while (!this.isElement(token, "dl"));
        while (true) {
            if (this.isBlockEnd(token = this.getToken()) || this.isElement(token, "/dl")) break;
            if (!this.isElement(token, "dt")) {
                String msg = "Unexpected element in inherited properties list";
                this.error(msg);
                throw new ParseException(msg);
            }
            StringBuffer text = new StringBuffer();
            while (true) {
                if (this.isBlockEnd(token = this.getToken()) || this.isElement(token, "/dl") || this.isElement(token, "dd") || this.isElement(token, "dt")) {
                    this.pushToken(token);
                    break;
                }
                if (this.isElement(token, "/dt")) break;
                if (token == 1) {
                    text.append(this.parser.getTokenText());
                    continue;
                }
                if (token != 3) continue;
                text.append(this.parser.getFullElement());
            }
            String propName = text.toString();
            DocInheritedProperty prop = new DocInheritedProperty();
            prop.setName(this.stripPara(propName));
            if (prop.isDefined(this.getElement())) {
                this.getElement().addInheritedPropertyNote(prop);
            } else {
                this.error("Inherited property " + prop.getName() + " is not defined in rom.def");
            }
            token = this.getToken();
            if (!this.isElement(token, "dd")) {
                this.pushToken(token);
                continue;
            }
            text = new StringBuffer();
            while (true) {
                if (this.isBlockEnd(token = this.getToken()) || this.isElement(token, "/dl") || this.isElement(token, "dt")) {
                    this.pushToken(token);
                    break;
                }
                if (this.isElement(token, "/dd")) break;
                if (token == 1) {
                    text.append(this.parser.getTokenText());
                    continue;
                }
                if (token != 3) continue;
                text.append(this.parser.getFullElement());
            }
            prop.setDescription(this.stripPara(text.toString()));
        }
        this.pushToken(token);
        token = this.getToken();
        if (!this.isElement(token, "/dl")) {
            this.pushToken(token);
        }
    }

    @Override
    public String getTail(String header, String suffix) {
        return header.substring(0, header.length() - suffix.length()).trim();
    }

    private void parseMembers() throws ParseException {
        String header;
        while (true) {
            int token;
            if (this.isElement(token = this.getToken(), "/body") || this.isElement(token, "/html")) {
                this.pushToken(token);
                return;
            }
            if (token != 3 || !this.isElement(token, "h2")) {
                String msg = "Unexpected token while reading members.";
                this.error(msg);
                throw new ParseException(msg);
            }
            String type = this.parser.getAttrib("class");
            token = this.getToken();
            if (token != 1) {
                String msg = "Missing member header.";
                this.error(msg);
                throw new ParseException(msg);
            }
            header = this.parser.getTokenText();
            if (type == null) {
                String msg = "Missing class to identify type: " + header;
                this.error(msg);
                throw new ParseException(msg);
            }
            token = this.getToken();
            if (!this.isElement(token, "/h2")) {
                this.pushToken(token);
            }
            if (type.equals("property")) {
                this.parseProperty(header);
                continue;
            }
            if (this.docObj.isElement() && type.equals("method")) {
                this.parseMethod(header);
                continue;
            }
            if (!this.docObj.isElement() || !type.equals("slot")) break;
            this.parseSlot(header);
        }
        String msg = "Unrecognized member class: " + header;
        this.error(msg);
        throw new ParseException(msg);
    }

    private String parseHeader() throws ParseException {
        String header;
        while (true) {
            int token;
            if ((token = this.getToken()) == -1) {
                return null;
            }
            if (this.isElement(token, "h2") || this.isElement(token, "/body") || this.isElement(token, "/html")) {
                this.pushToken(token);
                return null;
            }
            assert (this.isElement(token, "h3"));
            token = this.getToken();
            if (this.isElement(token, "/h3")) {
                this.warning("Blank section header");
                this.pushToken(token);
            } else if (token != 1) {
                String msg = "Unexpected element inside section header";
                this.error(msg);
                throw new ParseException(msg);
            }
            header = this.parser.getTokenText();
            token = this.getToken();
            if (!this.isElement(token, "/h3")) {
                this.pushToken(token);
            }
            if (header.equalsIgnoreCase("Issues")) {
                this.copySection();
                continue;
            }
            if (!header.equalsIgnoreCase("Summary")) break;
            this.copySection();
        }
        return header;
    }

    private void parseProperty(String name) throws ParseException {
        String header;
        DocProperty prop = this.docObj.getProperty(name);
        if (prop == null) {
            this.error("Property " + name + " is not defined in rom.def.");
        }
        String value = this.copySection();
        if (prop != null) {
            prop.setSummary(this.stripPara(value));
        }
        while ((header = this.parseHeader()) != null) {
            if (header.equalsIgnoreCase("Description")) {
                value = this.copySection();
                if (prop == null) continue;
                prop.setDescription(value);
                continue;
            }
            if (header.equalsIgnoreCase("Notes")) {
                this.parseNotes(prop);
                continue;
            }
            if (header.equalsIgnoreCase("Choices")) {
                this.parseChoices(prop);
                continue;
            }
            if (header.equalsIgnoreCase("See Also")) {
                value = this.copySection();
                if (prop == null) continue;
                prop.setSeeAlso(value);
                continue;
            }
            this.warning("Unexpected Property header: " + header);
            this.copySection();
        }
    }

    private void parseNotes(DocProperty prop) {
        while (true) {
            String note;
            int posn;
            int token;
            if (this.isBlockEnd(token = this.getToken())) {
                this.pushToken(token);
                return;
            }
            if (!this.isElement(token, "p") || (posn = (note = this.getTextTo("/p")).indexOf(58)) == -1) continue;
            String key = note.substring(0, posn);
            note = note.substring(posn + 1).trim();
            prop.addNote(key, note);
        }
    }

    private void parseChoices(DocProperty prop) throws ParseException {
        int token = this.getToken();
        if (this.isBlockEnd(token)) {
            this.pushToken(token);
            return;
        }
        if (!this.isElement(token, "ul")) {
            String msg = "Expected <ul> within Choices header.";
            this.error(msg);
            throw new ParseException(msg);
        }
        while (!this.isElement(token = this.getToken(), "/ul")) {
            if (this.isBlockEnd(token)) {
                this.error("</ul> missing from Choices section");
                this.pushToken(token);
                break;
            }
            if (!this.isElement(token, "li")) {
                String msg = "Expecting <li> within <ul> in Choices section";
                this.error(msg);
                throw new ParseException(msg);
            }
            String line = this.getTextTo("/li");
            int posn = line.indexOf(58);
            if (posn == -1) continue;
            String name = line.substring(0, posn);
            String descrip = line.substring(posn + 1).trim();
            DocChoice choice = prop.findChoice(name);
            if (choice == null) {
                this.error("Choice " + name + " is not defined in rom.def");
                continue;
            }
            choice.setDescription(descrip);
        }
    }

    private void parseMethod(String name) throws ParseException {
        String header;
        DocMethod method = this.getElement().getMethod(name);
        if (method == null) {
            this.error("Property " + name + " is not defined in rom.def.");
        }
        String value = this.copySection();
        if (method != null) {
            method.setSummary(this.stripPara(value));
        }
        while ((header = this.parseHeader()) != null) {
            if (header.equalsIgnoreCase("Description")) {
                value = this.copySection();
                if (method == null) continue;
                method.setDescription(value);
                continue;
            }
            if (header.equalsIgnoreCase("Return")) {
                value = this.copySection();
                if (method == null) continue;
                method.setReturnText(value);
                continue;
            }
            if (header.equalsIgnoreCase("See Also")) {
                value = this.copySection();
                if (method == null) continue;
                method.setSeeAlso(value);
                continue;
            }
            this.warning("Unexpected Method header: " + header);
            this.copySection();
        }
    }

    private void parseSlot(String name) throws ParseException {
        String header;
        DocSlot slot = this.getElement().getSlot(name);
        if (slot == null) {
            this.error("Slot " + name + " is not defined in rom.def.");
        }
        String value = this.copySection();
        if (slot != null) {
            slot.setSummary(this.stripPara(value));
        }
        while ((header = this.parseHeader()) != null) {
            if (header.equalsIgnoreCase("Description")) {
                value = this.copySection();
                if (slot == null) continue;
                slot.setDescription(value);
                continue;
            }
            if (header.equalsIgnoreCase("See Also")) {
                value = this.copySection();
                if (slot == null) continue;
                slot.setSeeAlso(value);
                continue;
            }
            if (header.equalsIgnoreCase("Contents")) {
                value = this.copySection();
                if (slot == null) continue;
                slot.setContentInfo(value);
                continue;
            }
            this.warning("Unexpected Slot header: " + header);
            this.copySection();
        }
    }

    private String label() {
        return "[" + Integer.toString(this.parser.getLineNo()) + "] Element " + this.docObj.getName() + ": ";
    }

    private void warning(String msg) {
        System.out.print(this.label());
        System.out.println(msg);
    }

    private void error(String msg) {
        System.err.print(this.label());
        System.err.println(msg);
    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseException(String msg) {
            super(msg);
        }
    }
}

