/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutedAfterChangeSetFilter
implements ChangeSetFilter {
    private Set<String> changeLogsAfterDate = new HashSet<String>();

    public ExecutedAfterChangeSetFilter(Date date, List<RanChangeSet> ranChangeSets) {
        for (RanChangeSet ranChangeSet : ranChangeSets) {
            if (ranChangeSet.getDateExecuted() == null || ranChangeSet.getDateExecuted().getTime() <= date.getTime()) continue;
            this.changeLogsAfterDate.add(this.changeLogToString(ranChangeSet.getId(), ranChangeSet.getAuthor(), ranChangeSet.getChangeLog()));
        }
    }

    private String changeLogToString(String id, String author, String changeLog) {
        return id + ":" + author + ":" + changeLog;
    }

    @Override
    public boolean accepts(ChangeSet changeSet) {
        return this.changeLogsAfterDate.contains(this.changeLogToString(changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath()));
    }
}

