/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.ArrayList;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.database.Database;
import liquibase.sql.visitor.SqlVisitor;

public class DbmsChangeSetFilter
implements ChangeSetFilter {
    private String databaseString;

    public DbmsChangeSetFilter(Database database) {
        this.databaseString = database.getTypeName();
    }

    public boolean accepts(ChangeSet changeSet) {
        ArrayList<SqlVisitor> visitorsToRemove = new ArrayList<SqlVisitor>();
        for (SqlVisitor visitor : changeSet.getSqlVisitors()) {
            if (this.databaseString == null || visitor.getApplicableDbms() == null || visitor.getApplicableDbms().size() <= 0) continue;
            boolean shouldRemove = true;
            if (visitor.getApplicableDbms().contains(this.databaseString)) {
                shouldRemove = false;
            }
            if (!shouldRemove) continue;
            visitorsToRemove.add(visitor);
        }
        changeSet.getSqlVisitors().removeAll(visitorsToRemove);
        if (this.databaseString == null) {
            return true;
        }
        if (changeSet.getDbmsSet() == null) {
            return true;
        }
        for (String dbms : changeSet.getDbmsSet()) {
            if (!this.databaseString.equals(dbms)) continue;
            return true;
        }
        return false;
    }
}

