/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.Arrays;
import liquibase.change.AbstractChange;
import liquibase.change.ColumnConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.DropColumnChange;
import liquibase.database.Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.structure.Index;
import liquibase.exception.UnsupportedChangeException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StringUtils;

public class MergeColumnChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String column1Name;
    private String joinString;
    private String column2Name;
    private String finalColumnName;
    private String finalColumnType;

    public MergeColumnChange() {
        super("mergeColumns", "Merge Column", 1);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumn1Name() {
        return this.column1Name;
    }

    public void setColumn1Name(String column1Name) {
        this.column1Name = column1Name;
    }

    public String getJoinString() {
        return this.joinString;
    }

    public void setJoinString(String joinString) {
        this.joinString = joinString;
    }

    public String getColumn2Name() {
        return this.column2Name;
    }

    public void setColumn2Name(String column2Name) {
        this.column2Name = column2Name;
    }

    public String getFinalColumnName() {
        return this.finalColumnName;
    }

    public void setFinalColumnName(String finalColumnName) {
        this.finalColumnName = finalColumnName;
    }

    public String getFinalColumnType() {
        return this.finalColumnType;
    }

    public void setFinalColumnType(String finalColumnType) {
        this.finalColumnType = finalColumnType;
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        AddColumnChange addNewColumnChange = new AddColumnChange();
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        addNewColumnChange.setSchemaName(schemaName);
        addNewColumnChange.setTableName(this.getTableName());
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName(this.getFinalColumnName());
        columnConfig.setType(this.getFinalColumnType());
        addNewColumnChange.addColumn(columnConfig);
        statements.addAll(Arrays.asList(addNewColumnChange.generateStatements(database)));
        String updateStatement = "UPDATE " + database.escapeTableName(schemaName, this.getTableName()) + " SET " + this.getFinalColumnName() + " = " + database.getConcatSql(this.getColumn1Name(), "'" + this.getJoinString() + "'", this.getColumn2Name());
        statements.add(new RawSqlStatement(updateStatement));
        if (database instanceof SQLiteDatabase) {
            SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

                public ColumnConfig[] getColumnsToAdd() {
                    ColumnConfig[] new_columns = new ColumnConfig[1];
                    ColumnConfig new_column = new ColumnConfig();
                    new_column.setName(MergeColumnChange.this.getFinalColumnName());
                    new_column.setType(MergeColumnChange.this.getFinalColumnType());
                    new_columns[0] = new ColumnConfig(new_column);
                    return new_columns;
                }

                public boolean copyThisColumn(ColumnConfig column) {
                    return !column.getName().equals(MergeColumnChange.this.getColumn1Name()) && !column.getName().equals(MergeColumnChange.this.getColumn2Name());
                }

                public boolean createThisColumn(ColumnConfig column) {
                    return !column.getName().equals(MergeColumnChange.this.getColumn1Name()) && !column.getName().equals(MergeColumnChange.this.getColumn2Name());
                }

                public boolean createThisIndex(Index index) {
                    return !index.getColumns().contains(MergeColumnChange.this.getColumn1Name()) && !index.getColumns().contains(MergeColumnChange.this.getColumn2Name());
                }
            };
            try {
                statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            DropColumnChange dropColumn1Change = new DropColumnChange();
            dropColumn1Change.setSchemaName(schemaName);
            dropColumn1Change.setTableName(this.getTableName());
            dropColumn1Change.setColumnName(this.getColumn1Name());
            statements.addAll(Arrays.asList(dropColumn1Change.generateStatements(database)));
            DropColumnChange dropColumn2Change = new DropColumnChange();
            dropColumn2Change.setSchemaName(schemaName);
            dropColumn2Change.setTableName(this.getTableName());
            dropColumn2Change.setColumnName(this.getColumn2Name());
            statements.addAll(Arrays.asList(dropColumn2Change.generateStatements(database)));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    public SqlStatement[] generateStatements(DerbyDatabase database) throws UnsupportedChangeException {
        throw new UnsupportedChangeException("Derby does not currently support merging columns");
    }

    public String getConfirmationMessage() {
        return "Columns " + this.getTableName() + "." + this.getColumn1Name() + " and " + this.getTableName() + "." + this.getColumn2Name() + " merged";
    }
}

