/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.util.Arrays;
import org.apache.batik.gvt.font.UnicodeRange;

public class Kern {
    private int[] firstGlyphCodes;
    private int[] secondGlyphCodes;
    private UnicodeRange[] firstUnicodeRanges;
    private UnicodeRange[] secondUnicodeRanges;
    private float kerningAdjust;

    public Kern(int[] nArray, int[] nArray2, UnicodeRange[] unicodeRangeArray, UnicodeRange[] unicodeRangeArray2, float f) {
        this.firstGlyphCodes = nArray;
        this.secondGlyphCodes = nArray2;
        this.firstUnicodeRanges = unicodeRangeArray;
        this.secondUnicodeRanges = unicodeRangeArray2;
        this.kerningAdjust = f;
        if (nArray != null) {
            Arrays.sort(this.firstGlyphCodes);
        }
        if (nArray2 != null) {
            Arrays.sort(this.secondGlyphCodes);
        }
    }

    public boolean matchesFirstGlyph(int n, String string) {
        int n2;
        if (this.firstGlyphCodes != null && (n2 = Arrays.binarySearch(this.firstGlyphCodes, n)) >= 0) {
            return true;
        }
        if (string.length() < 1) {
            return false;
        }
        n2 = string.charAt(0);
        int n3 = 0;
        while (n3 < this.firstUnicodeRanges.length) {
            if (this.firstUnicodeRanges[n3].contains(n2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean matchesFirstGlyph(int n, char c) {
        int n2;
        if (this.firstGlyphCodes != null && (n2 = Arrays.binarySearch(this.firstGlyphCodes, n)) >= 0) {
            return true;
        }
        n2 = 0;
        while (n2 < this.firstUnicodeRanges.length) {
            if (this.firstUnicodeRanges[n2].contains(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean matchesSecondGlyph(int n, String string) {
        int n2;
        if (this.secondGlyphCodes != null && (n2 = Arrays.binarySearch(this.secondGlyphCodes, n)) >= 0) {
            return true;
        }
        if (string.length() < 1) {
            return false;
        }
        n2 = string.charAt(0);
        int n3 = 0;
        while (n3 < this.secondUnicodeRanges.length) {
            if (this.secondUnicodeRanges[n3].contains(n2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean matchesSecondGlyph(int n, char c) {
        int n2;
        if (this.secondGlyphCodes != null && (n2 = Arrays.binarySearch(this.secondGlyphCodes, n)) >= 0) {
            return true;
        }
        n2 = 0;
        while (n2 < this.secondUnicodeRanges.length) {
            if (this.secondUnicodeRanges[n2].contains(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public float getAdjustValue() {
        return this.kerningAdjust;
    }
}

