/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.BaseQuery;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultSetSpecification;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationHelper;

public class QuerySpecification {
    private ResultSetSpecification m_resultSpec;
    private Map<String, Object> m_propertyMap;
    private Map<ParameterIdentifier, Object> m_parameterValues;
    private BaseQuery m_baseQuery;
    private static final String sm_className = QuerySpecification.class.getName();

    QuerySpecification() {
    }

    public void setProperty(String propertyName, Object value) {
        this.getProperties().put(propertyName, value);
    }

    public Object getProperty(String propertyName) {
        if (this.m_propertyMap == null) {
            return null;
        }
        return this.m_propertyMap.get(propertyName);
    }

    public void setProperties(Map<String, Object> propertyMap) {
        this.m_propertyMap = propertyMap;
    }

    public Map<String, Object> getProperties() {
        if (this.m_propertyMap == null) {
            this.m_propertyMap = new HashMap<String, Object>(5);
        }
        return this.m_propertyMap;
    }

    public void setParameterValue(String parameterName, Object value) {
        this.setParameterValue(new ParameterIdentifier(parameterName), value);
    }

    public void setParameterValue(int parameterId, Object value) {
        this.setParameterValue(new ParameterIdentifier(parameterId), value);
    }

    public void setParameterValue(ParameterIdentifier paramIdentifier, Object value) {
        this.getParameterValues().put(paramIdentifier, value);
    }

    public Object getParameterValue(String parameterName) {
        return this.getParameterValue(new ParameterIdentifier(parameterName));
    }

    public Object getParameterValue(int parameterId) {
        return this.getParameterValue(new ParameterIdentifier(parameterId));
    }

    public Object getParameterValue(ParameterIdentifier paramIdentifier) {
        if (this.m_parameterValues == null) {
            return null;
        }
        Object paramValue = this.m_parameterValues.get(paramIdentifier);
        if (paramValue != null) {
            return paramValue;
        }
        for (Map.Entry<ParameterIdentifier, Object> entry : this.m_parameterValues.entrySet()) {
            ParameterIdentifier paramIdKey = entry.getKey();
            if (!paramIdKey.matchesByNameOrId(paramIdentifier)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void setParameterValues(Map<ParameterIdentifier, Object> paramValues) {
        this.m_parameterValues = paramValues;
    }

    public Map<ParameterIdentifier, Object> getParameterValues() {
        if (this.m_parameterValues == null) {
            this.m_parameterValues = new HashMap<ParameterIdentifier, Object>(5);
        }
        return this.m_parameterValues;
    }

    public void setResultSetSpecification(ResultSetSpecification resultSpec) {
        this.m_resultSpec = resultSpec;
    }

    public ResultSetSpecification getResultSetSpecification() {
        return this.m_resultSpec;
    }

    public boolean hasResultSetSpecification() {
        ResultSetSpecification resultSetSpec = this.getResultSetSpecification();
        return resultSetSpec != null && !resultSetSpec.isEmpty();
    }

    public void setBaseQuery(BaseQuery baseQuery) {
        this.m_baseQuery = baseQuery;
    }

    public BaseQuery getBaseQuery() {
        return this.m_baseQuery;
    }

    public void validate(ValidationContext context) throws OdaException {
        try {
            if (context != null && context.getValidator() != null) {
                context.getValidator().validate(this, context);
            }
        }
        catch (OdaException ex) {
            QuerySpecificationHelper.logValidationException(sm_className, ex);
            throw ex;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(QuerySpecification.class.getSimpleName());
        buffer.append("\n    { property count: ");
        buffer.append(this.getProperties().size());
        buffer.append(" }; { parameter count: ");
        buffer.append(this.getParameterValues().size());
        buffer.append(" }\n    { base query: ");
        buffer.append(this.m_baseQuery);
        buffer.append(" }\n    { resultSpec: ");
        buffer.append(this.m_resultSpec);
        buffer.append(" }");
        return buffer.toString();
    }

    public class ParameterIdentifier {
        private String m_paramName;
        private Integer m_paramId;
        private static final String LOG_CLASSNAME_PREFIX = "ParameterIdentifier@";
        private static final String LOG_ID_LABEL = " [id= ";
        private static final String LOG_NAME_LABEL = ", name= ";
        private static final String LOG_END_BRACKET = "]";

        public ParameterIdentifier(String paramName) {
            this.setParameterName(paramName);
        }

        public ParameterIdentifier(int paramId) {
            this.setParameterId(paramId);
        }

        public ParameterIdentifier(String paramName, int paramId) {
            this.setParameterName(paramName);
            this.setParameterId(paramId);
        }

        private void setParameterId(int paramId) {
            if (paramId < 1) {
                throw new IllegalArgumentException(Integer.valueOf(paramId).toString());
            }
            this.m_paramId = paramId;
        }

        private void setParameterName(String paramName) {
            if (paramName == null || paramName.length() == 0) {
                throw new IllegalArgumentException(paramName);
            }
            this.m_paramName = paramName;
        }

        public Integer getParameterId() {
            return this.m_paramId;
        }

        public String getParameterName() {
            return this.m_paramName;
        }

        public boolean hasName() {
            return this.m_paramName != null && this.m_paramName.length() > 0;
        }

        public boolean hasId() {
            return this.m_paramId != null && this.m_paramId > 0;
        }

        private boolean matchesByNameOrId(Object obj) {
            if (!(obj instanceof ParameterIdentifier)) {
                return false;
            }
            ParameterIdentifier thatObj = (ParameterIdentifier)obj;
            if (this == thatObj) {
                return true;
            }
            boolean matchesName = false;
            if (this.hasName() && thatObj.hasName()) {
                if (this.m_paramName.equals(thatObj.m_paramName)) {
                    matchesName = true;
                } else {
                    return false;
                }
            }
            if (this.hasId() && thatObj.hasId()) {
                return this.m_paramId.equals(thatObj.m_paramId);
            }
            return matchesName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParameterIdentifier)) {
                return false;
            }
            ParameterIdentifier thatObj = (ParameterIdentifier)obj;
            if (this == thatObj) {
                return true;
            }
            boolean isNameEqual = false;
            if (this.hasName()) {
                if (this.m_paramName.equals(thatObj.m_paramName)) {
                    isNameEqual = true;
                } else {
                    return false;
                }
            }
            if (this.hasId()) {
                return this.m_paramId.equals(thatObj.m_paramId);
            }
            return isNameEqual;
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.hasName()) {
                hashCode = this.m_paramName.hashCode();
            }
            if (this.hasId()) {
                return hashCode ^ this.m_paramId.hashCode();
            }
            return hashCode == 0 ? super.hashCode() : hashCode;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(LOG_CLASSNAME_PREFIX);
            buffer.append(super.hashCode());
            buffer.append(LOG_ID_LABEL);
            buffer.append(this.m_paramId);
            buffer.append(LOG_NAME_LABEL);
            buffer.append(this.m_paramName);
            buffer.append(LOG_END_BRACKET);
            return buffer.toString();
        }
    }
}

