/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.ModifyDataTypeStatement;

public class ModifyDataTypeChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String newDataType;

    public ModifyDataTypeChange() {
        super("modifyDataType", "Modify data type", 1);
    }

    public String getConfirmationMessage() {
        return this.tableName + "." + this.columnName + " datatype was changed to " + this.newDataType;
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new ModifyDataTypeStatement(this.getSchemaName(), this.getTableName(), this.getColumnName(), this.getNewDataType())};
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getNewDataType() {
        return this.newDataType;
    }

    public void setNewDataType(String newDataType) {
        this.newDataType = newDataType;
    }
}

