/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.statistics;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.LiveCacheStatistics;
import net.sf.ehcache.statistics.LiveCacheStatisticsData;
import net.sf.ehcache.statistics.LiveCacheStatisticsImpl;
import net.sf.ehcache.statistics.NullLiveCacheStatisticsData;

public class LiveCacheStatisticsWrapper
implements LiveCacheStatistics,
LiveCacheStatisticsData {
    private static final LiveCacheStatistics NULL_LIVE_CACHE_STATISTICS = new NullLiveCacheStatisticsData();
    private final LiveCacheStatisticsImpl liveDelegate;
    private volatile LiveCacheStatistics delegate;

    public LiveCacheStatisticsWrapper(Ehcache cache) {
        this.liveDelegate = new LiveCacheStatisticsImpl(cache);
        this.setStatisticsEnabled(true);
    }

    @Override
    public void setStatisticsEnabled(boolean enableStatistics) {
        this.delegate = enableStatistics ? this.liveDelegate : NULL_LIVE_CACHE_STATISTICS;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.delegate instanceof LiveCacheStatisticsImpl;
    }

    @Override
    public void registerCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.liveDelegate.registerCacheUsageListener(cacheUsageListener);
    }

    @Override
    public void removeCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.liveDelegate.removeCacheUsageListener(cacheUsageListener);
    }

    @Override
    public void setStatisticsAccuracy(int statisticsAccuracy) {
        this.liveDelegate.setStatisticsAccuracy(statisticsAccuracy);
    }

    @Override
    public int getStatisticsAccuracy() {
        return this.liveDelegate.getStatisticsAccuracy();
    }

    @Override
    public String getStatisticsAccuracyDescription() {
        return this.liveDelegate.getStatisticsAccuracyDescription();
    }

    @Override
    public String getCacheName() {
        return this.liveDelegate.getCacheName();
    }

    @Override
    public long getSize() {
        return this.delegate.getSize();
    }

    @Override
    @Deprecated
    public long getInMemorySize() {
        return this.delegate.getInMemorySize();
    }

    @Override
    @Deprecated
    public long getOffHeapSize() {
        return this.delegate.getOffHeapSize();
    }

    @Override
    @Deprecated
    public long getOnDiskSize() {
        return this.delegate.getOnDiskSize();
    }

    @Override
    public long getLocalHeapSize() {
        return this.delegate.getLocalHeapSize();
    }

    @Override
    public long getLocalOffHeapSize() {
        return this.delegate.getLocalOffHeapSize();
    }

    @Override
    public long getLocalDiskSize() {
        return this.delegate.getLocalDiskSize();
    }

    @Override
    public long getLocalHeapSizeInBytes() {
        return this.delegate.getLocalHeapSizeInBytes();
    }

    @Override
    public long getLocalOffHeapSizeInBytes() {
        return this.delegate.getLocalOffHeapSizeInBytes();
    }

    @Override
    public long getLocalDiskSizeInBytes() {
        return this.delegate.getLocalDiskSizeInBytes();
    }

    @Override
    public float getAverageGetTimeMillis() {
        return this.delegate.getAverageGetTimeMillis();
    }

    @Override
    public long getAverageGetTimeNanos() {
        return this.delegate.getAverageGetTimeNanos();
    }

    @Override
    public long getCacheHitCount() {
        return this.delegate.getCacheHitCount();
    }

    @Override
    public long getCacheMissCount() {
        return this.delegate.getCacheMissCount();
    }

    @Override
    public long getInMemoryMissCount() {
        return this.delegate.getInMemoryMissCount();
    }

    @Override
    public long getOffHeapMissCount() {
        return this.delegate.getOffHeapMissCount();
    }

    @Override
    public long getOnDiskMissCount() {
        return this.delegate.getOnDiskMissCount();
    }

    @Override
    public long getCacheMissCountExpired() {
        return this.delegate.getCacheMissCountExpired();
    }

    @Override
    public int getCacheHitRatio() {
        return this.delegate.getCacheHitRatio();
    }

    @Override
    public long getEvictedCount() {
        return this.delegate.getEvictedCount();
    }

    @Override
    public long getExpiredCount() {
        return this.delegate.getExpiredCount();
    }

    @Override
    public long getInMemoryHitCount() {
        return this.delegate.getInMemoryHitCount();
    }

    @Override
    public long getOffHeapHitCount() {
        return this.delegate.getOffHeapHitCount();
    }

    @Override
    public long getOnDiskHitCount() {
        return this.delegate.getOnDiskHitCount();
    }

    @Override
    public long getPutCount() {
        return this.delegate.getPutCount();
    }

    @Override
    public long getRemovedCount() {
        return this.delegate.getRemovedCount();
    }

    @Override
    public long getUpdateCount() {
        return this.delegate.getUpdateCount();
    }

    private LiveCacheStatisticsData getDelegateAsLiveStatisticsData() {
        return (LiveCacheStatisticsData)((Object)this.delegate);
    }

    @Override
    public void addGetTimeMillis(long millis) {
        this.getDelegateAsLiveStatisticsData().addGetTimeMillis(millis);
    }

    @Override
    public void addGetTimeNanos(long nanos) {
        this.getDelegateAsLiveStatisticsData().addGetTimeNanos(nanos);
    }

    @Override
    @Deprecated
    public long getMaxGetTimeMillis() {
        return this.delegate.getMaxGetTimeMillis();
    }

    @Override
    @Deprecated
    public long getMinGetTimeMillis() {
        return this.delegate.getMinGetTimeMillis();
    }

    @Override
    public long getMaxGetTimeNanos() {
        return this.delegate.getMaxGetTimeNanos();
    }

    @Override
    public long getMinGetTimeNanos() {
        return this.delegate.getMinGetTimeNanos();
    }

    @Override
    public long getXaCommitCount() {
        return this.delegate.getXaCommitCount();
    }

    @Override
    public long getXaRollbackCount() {
        return this.delegate.getXaRollbackCount();
    }

    @Override
    public long getXaRecoveredCount() {
        return this.delegate.getXaRecoveredCount();
    }

    @Override
    public long getWriterQueueLength() {
        return this.delegate.getWriterQueueLength();
    }

    @Override
    public void cacheHitInMemory() {
        this.getDelegateAsLiveStatisticsData().cacheHitInMemory();
    }

    @Override
    public void cacheHitOffHeap() {
        this.getDelegateAsLiveStatisticsData().cacheHitOffHeap();
    }

    @Override
    public void cacheHitOnDisk() {
        this.getDelegateAsLiveStatisticsData().cacheHitOnDisk();
    }

    @Override
    public void cacheMissExpired() {
        this.getDelegateAsLiveStatisticsData().cacheMissExpired();
    }

    @Override
    public void xaCommit() {
        this.getDelegateAsLiveStatisticsData().xaCommit();
    }

    @Override
    public void xaRollback() {
        this.getDelegateAsLiveStatisticsData().xaRollback();
    }

    @Override
    public void xaRecovered(int count) {
        this.getDelegateAsLiveStatisticsData().xaRecovered(count);
    }

    @Override
    public void cacheMissNotFound() {
        this.getDelegateAsLiveStatisticsData().cacheMissNotFound();
    }

    @Override
    public void cacheMissInMemory() {
        this.getDelegateAsLiveStatisticsData().cacheMissInMemory();
    }

    @Override
    public void cacheMissOffHeap() {
        this.getDelegateAsLiveStatisticsData().cacheMissOffHeap();
    }

    @Override
    public void cacheMissOnDisk() {
        this.getDelegateAsLiveStatisticsData().cacheMissOnDisk();
    }

    @Override
    public void clearStatistics() {
        this.getDelegateAsLiveStatisticsData().clearStatistics();
    }

    @Override
    public void dispose() {
        this.getDelegateAsLiveStatisticsData().dispose();
    }

    @Override
    public void notifyElementEvicted(Ehcache cache, Element element) {
        this.getDelegateAsLiveStatisticsData().notifyElementEvicted(cache, element);
    }

    @Override
    public void notifyElementExpired(Ehcache cache, Element element) {
        this.getDelegateAsLiveStatisticsData().notifyElementExpired(cache, element);
    }

    @Override
    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        this.getDelegateAsLiveStatisticsData().notifyElementPut(cache, element);
    }

    @Override
    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        this.getDelegateAsLiveStatisticsData().notifyElementRemoved(cache, element);
    }

    @Override
    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        this.getDelegateAsLiveStatisticsData().notifyElementUpdated(cache, element);
    }

    @Override
    public void notifyRemoveAll(Ehcache cache) {
        this.getDelegateAsLiveStatisticsData().notifyRemoveAll(cache);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        super.clone();
        throw new CloneNotSupportedException();
    }
}

