/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonImpl;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationImpl;
import fr.ifremer.adagio.core.dao.data.sample.Sample;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Matrix;
import fr.ifremer.adagio.core.dao.referential.pmfm.MatrixImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AccidentalBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.SamplePersistenceHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.IntegerType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="accidentalBatchPersistenceService")
public class AccidentalBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements AccidentalBatchPersistenceService {
    private static final Log log = LogFactory.getLog(AccidentalBatchPersistenceServiceImpl.class);
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Resource(name="samplePersistenceHelper")
    protected SamplePersistenceHelper samplePersistenceHelper;

    @Override
    public List<AccidentalBatch> getAllAccidentalBatch(String fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        Iterator<Object[]> list = this.queryList("allFishingOperationSamplesWithoutBatch", "fishingOperationId", IntegerType.INSTANCE, Integer.valueOf(fishingOperationId));
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            AccidentalBatch accidentalBatch = AccidentalBatchs.newAccidentalBatch();
            int colIndex = 0;
            accidentalBatch.setId((Integer)source[colIndex++]);
            Integer taxonId = (Integer)source[colIndex++];
            Species species = this.referentialService.getSpeciesByReferenceTaxonId(taxonId);
            accidentalBatch.setSpecies(species);
            accidentalBatch.setComment((String)source[colIndex]);
            accidentalBatch.setCaracteristics(new CaracteristicMap());
            this.fillSampleMeasurements(accidentalBatch);
            result.add(accidentalBatch);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public AccidentalBatch createAccidentalBatch(AccidentalBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkState((boolean)TuttiEntities.isNew(bean));
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkState((!TuttiEntities.isNew(bean.getFishingOperation()) ? 1 : 0) != 0);
        Sample sample = Sample.Factory.newInstance();
        this.beanToEntity(bean, sample);
        this.samplePersistenceHelper.create(sample);
        bean.setId(String.valueOf(sample.getId()));
        return bean;
    }

    @Override
    public AccidentalBatch saveAccidentalBatch(AccidentalBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkState((!TuttiEntities.isNew(bean) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkState((!TuttiEntities.isNew(bean.getFishingOperation()) ? 1 : 0) != 0);
        Sample sample = this.samplePersistenceHelper.load(bean.getIdAsInt());
        if (sample == null) {
            throw new DataRetrievalFailureException("Could not retrieve sample id=" + bean.getId());
        }
        this.beanToEntity(bean, sample);
        this.samplePersistenceHelper.update(sample);
        return bean;
    }

    @Override
    public void deleteAccidentalBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        Integer batchId = Integer.valueOf(id);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete accidental batch: " + batchId));
        }
        this.samplePersistenceHelper.deleteSample(batchId);
    }

    @Override
    public void deleteAccidentalBatchForFishingOperation(String fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        List<AccidentalBatch> batches = this.getAllAccidentalBatch(fishingOperationId);
        if (CollectionUtils.isNotEmpty(batches)) {
            for (AccidentalBatch batch : batches) {
                this.deleteAccidentalBatch(batch.getId());
            }
        }
    }

    protected void beanToEntity(AccidentalBatch source, Sample target) {
        Caracteristic caracteristic;
        if (TuttiEntities.isNew(source)) {
            FishingOperation fishingOperation = (FishingOperation)this.load(FishingOperationImpl.class, source.getFishingOperation().getIdAsInt());
            fishingOperation.getSamples().add(target);
            target.setFishingOperation(fishingOperation);
            String label = fishingOperation.getId() + "_" + source.getSpecies().getReferenceTaxonId();
            target.setLabel(label);
            Matrix matrix = (Matrix)this.load(MatrixImpl.class, this.enumeration.MATRIX_ID_PRODUCT_BATCH);
            target.setMatrix(matrix);
            target.setIndividualCount(Short.valueOf((short)1));
            target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
            if (target.getSampleDate() == null) {
                target.setSampleDate(fishingOperation.getFishingStartDateTime());
            }
            target.setCreationDate(fishingOperation.getFishingStartDateTime());
            target.setRecorderDepartment((Department)this.load(DepartmentImpl.class, this.enumeration.DEPARTMENT_ID_UNKNOWN_RECORDER_DEPARTMENT));
            target.setRecorderPerson((Person)this.load(PersonImpl.class, this.enumeration.PERSON_ID_UNKNOWN_RECORDER_PERSON));
            Program program = fishingOperation.getFishingTrip().getProgram();
            target.setProgram(program);
        }
        target.setId(source.getIdAsInt());
        target.setBatch(null);
        target.setSynchronizationStatus(SynchronizationStatus.DIRTY.getValue());
        target.setComments(source.getComment());
        Species species = source.getSpecies();
        Integer referenceTaxonId = species.getReferenceTaxonId();
        target.setReferenceTaxon((ReferenceTaxon)this.load(ReferenceTaxonImpl.class, referenceTaxonId));
        CaracteristicMap caracteristics = CaracteristicMap.copy(source.getCaracteristics());
        if (source.getDeadOrAlive() != null) {
            caracteristic = this.referentialService.getDeadOrAliveCaracteristic();
            caracteristics.put(caracteristic, source.getDeadOrAlive());
        }
        if (source.getGender() != null) {
            caracteristic = this.referentialService.getSexCaracteristic();
            caracteristics.put(caracteristic, source.getGender());
        }
        if (source.getWeight() != null) {
            caracteristic = this.referentialService.getWeightMeasuredCaracteristic();
            caracteristics.put(caracteristic, source.getWeight());
        }
        if (source.getLengthStepCaracteristic() != null) {
            caracteristic = this.referentialService.getCaracteristic(this.enumeration.PMFM_ID_ID_PSFM);
            caracteristics.put(caracteristic, source.getLengthStepCaracteristic().getId());
            caracteristics.put(source.getLengthStepCaracteristic(), source.getSize());
        }
        this.samplePersistenceHelper.setSampleMeasurements(target, caracteristics);
    }

    protected void fillSampleMeasurements(AccidentalBatch batch) {
        String lengthClassId;
        Float weight;
        CaracteristicQualitativeValue genderValue;
        Caracteristic deadOrAliveCaracteristic = this.referentialService.getDeadOrAliveCaracteristic();
        Caracteristic genderCaracteristic = this.referentialService.getSexCaracteristic();
        CaracteristicMap result = batch.getCaracteristics();
        this.samplePersistenceHelper.fillSampleMeasurements(result, batch.getIdAsInt());
        CaracteristicQualitativeValue deadOrAliveValue = (CaracteristicQualitativeValue)result.remove(deadOrAliveCaracteristic);
        if (deadOrAliveValue != null) {
            batch.setDeadOrAlive(deadOrAliveValue);
        }
        if ((genderValue = (CaracteristicQualitativeValue)result.remove(genderCaracteristic)) != null) {
            batch.setGender(genderValue);
        }
        if ((weight = (Float)result.remove(this.referentialService.getCaracteristic(this.enumeration.PMFM_ID_WEIGHT_MEASURED))) != null) {
            batch.setWeight(weight);
        }
        if ((lengthClassId = (String)result.remove(this.referentialService.getCaracteristic(this.enumeration.PMFM_ID_ID_PSFM))) != null) {
            Caracteristic lengthStepCaracteristic = this.referentialService.getCaracteristic(Integer.valueOf(lengthClassId));
            batch.setLengthStepCaracteristic(lengthStepCaracteristic);
            Serializable length = (Serializable)result.remove(lengthStepCaracteristic);
            batch.setSize((Float)length);
        }
    }
}

