/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.i18n;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class JdbcResourceHandle {
    protected UResourceBundle resources;
    private static final String BUNDLE_NAME = "Messages";

    public JdbcResourceHandle(ULocale locale) {
        String className = this.getClass().getName();
        String bundleName = "";
        int index = className.lastIndexOf(46);
        if (index > -1) {
            bundleName = String.valueOf(className.substring(0, index)) + ".";
        }
        bundleName = String.valueOf(bundleName) + BUNDLE_NAME;
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        this.resources = UResourceBundle.getBundleInstance((String)bundleName, (String)locale.getName(), (ClassLoader)this.getClass().getClassLoader());
        assert (this.resources != null) : "ResourceBundle : Messages for " + locale + " not found";
    }

    public JdbcResourceHandle(Locale locale) {
        this(ULocale.forLocale((Locale)locale));
    }

    public String getMessage(String key) {
        if (key == null) {
            return null;
        }
        try {
            return this.resources.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            assert (false) : String.valueOf(key) + " not found in resource bundle";
            return key;
        }
    }

    public String getMessage(String key, Object[] arguments) {
        String message = this.getMessage(key);
        return MessageFormat.format((String)message, (Object[])arguments);
    }

    public UResourceBundle getUResourceBundle() {
        return this.resources;
    }

    public ResourceBundle getResourceBundle() {
        return this.getUResourceBundle();
    }
}

