/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.core.DropForeignKeyConstraintChange;
import liquibase.database.Database;
import liquibase.database.structure.ForeignKeyConstraintType;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddForeignKeyConstraintStatement;

public class AddForeignKeyConstraintChange
extends AbstractChange {
    private String baseTableSchemaName;
    private String baseTableName;
    private String baseColumnNames;
    private String referencedTableSchemaName;
    private String referencedTableName;
    private String referencedColumnNames;
    private String constraintName;
    private Boolean deferrable;
    private Boolean initiallyDeferred;
    private String onUpdate;
    private String onDelete;
    private Boolean referencesUniqueColumn;

    public AddForeignKeyConstraintChange() {
        super("addForeignKeyConstraint", "Add Foreign Key Constraint", 1);
    }

    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public void setBaseTableSchemaName(String baseTableSchemaName) {
        this.baseTableSchemaName = baseTableSchemaName;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String baseTableName) {
        this.baseTableName = baseTableName;
    }

    public String getBaseColumnNames() {
        return this.baseColumnNames;
    }

    public void setBaseColumnNames(String baseColumnNames) {
        this.baseColumnNames = baseColumnNames;
    }

    public String getReferencedTableSchemaName() {
        return this.referencedTableSchemaName;
    }

    public void setReferencedTableSchemaName(String referencedTableSchemaName) {
        this.referencedTableSchemaName = referencedTableSchemaName;
    }

    public String getReferencedTableName() {
        return this.referencedTableName;
    }

    public void setReferencedTableName(String referencedTableName) {
        this.referencedTableName = referencedTableName;
    }

    public String getReferencedColumnNames() {
        return this.referencedColumnNames;
    }

    public void setReferencedColumnNames(String referencedColumnNames) {
        this.referencedColumnNames = referencedColumnNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public Boolean getDeferrable() {
        return this.deferrable;
    }

    public void setDeferrable(Boolean deferrable) {
        this.deferrable = deferrable;
    }

    public Boolean getInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    public void setInitiallyDeferred(Boolean initiallyDeferred) {
        this.initiallyDeferred = initiallyDeferred;
    }

    public void setDeleteCascade(Boolean deleteCascade) {
        if (deleteCascade != null && deleteCascade.booleanValue()) {
            this.setOnDelete("CASCADE");
        }
    }

    public void setOnUpdate(String rule) {
        this.onUpdate = rule;
    }

    public String getOnUpdate() {
        return this.onUpdate;
    }

    public void setOnDelete(String onDelete) {
        this.onDelete = onDelete;
    }

    public String getOnDelete() {
        return this.onDelete;
    }

    public Boolean getReferencesUniqueColumn() {
        return this.referencesUniqueColumn;
    }

    public void setReferencesUniqueColumn(Boolean referencesUniqueColumn) {
        this.referencesUniqueColumn = referencesUniqueColumn;
    }

    public void setOnDelete(ForeignKeyConstraintType rule) {
        if (rule != null) {
            if (rule == ForeignKeyConstraintType.importedKeyCascade) {
                this.setOnDelete("CASCADE");
            } else if (rule == ForeignKeyConstraintType.importedKeySetNull) {
                this.setOnDelete("SET NULL");
            } else if (rule == ForeignKeyConstraintType.importedKeySetDefault) {
                this.setOnDelete("SET DEFAULT");
            } else if (rule == ForeignKeyConstraintType.importedKeyRestrict) {
                this.setOnDelete("RESTRICT");
            } else if (rule == ForeignKeyConstraintType.importedKeyNoAction) {
                this.setOnDelete("NO ACTION");
            } else {
                throw new UnexpectedLiquibaseException("Unknown onDelete action: " + (Object)((Object)rule));
            }
        }
    }

    public void setOnUpdate(ForeignKeyConstraintType rule) {
        if (rule != null) {
            if (rule == ForeignKeyConstraintType.importedKeyCascade) {
                this.setOnUpdate("CASCADE");
            } else if (rule == ForeignKeyConstraintType.importedKeySetNull) {
                this.setOnUpdate("SET NULL");
            } else if (rule == ForeignKeyConstraintType.importedKeySetDefault) {
                this.setOnUpdate("SET DEFAULT");
            } else if (rule == ForeignKeyConstraintType.importedKeyRestrict) {
                this.setOnUpdate("RESTRICT");
            } else if (rule == ForeignKeyConstraintType.importedKeyNoAction) {
                this.setOnUpdate("NO ACTION");
            } else {
                throw new UnexpectedLiquibaseException("Unknown onUpdate action: " + this.onUpdate);
            }
        }
    }

    public SqlStatement[] generateStatements(Database database) {
        boolean deferrable = false;
        if (this.getDeferrable() != null) {
            deferrable = this.getDeferrable();
        }
        boolean initiallyDeferred = false;
        if (this.getInitiallyDeferred() != null) {
            initiallyDeferred = this.getInitiallyDeferred();
        }
        return new SqlStatement[]{new AddForeignKeyConstraintStatement(this.getConstraintName(), this.getBaseTableSchemaName() == null ? database.getDefaultSchemaName() : this.getBaseTableSchemaName(), this.getBaseTableName(), this.getBaseColumnNames(), this.getReferencedTableSchemaName() == null ? database.getDefaultSchemaName() : this.getReferencedTableSchemaName(), this.getReferencedTableName(), this.getReferencedColumnNames()).setDeferrable(deferrable).setInitiallyDeferred(initiallyDeferred).setOnUpdate(this.getOnUpdate()).setOnDelete(this.getOnDelete()).setReferencesUniqueColumn(this.getReferencesUniqueColumn())};
    }

    protected Change[] createInverses() {
        DropForeignKeyConstraintChange inverse = new DropForeignKeyConstraintChange();
        inverse.setBaseTableSchemaName(this.getBaseTableSchemaName());
        inverse.setBaseTableName(this.getBaseTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }

    public String getConfirmationMessage() {
        return "Foreign key contraint added to " + this.getBaseTableName() + " (" + this.getBaseColumnNames() + ")";
    }
}

