/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.impl.EmptySelection;
import org.eclipse.birt.data.engine.olap.data.impl.MultiKeySelection;
import org.eclipse.birt.data.engine.olap.data.impl.OneKeySelection;
import org.eclipse.birt.data.engine.olap.data.impl.RangeSelection;

public class SelectionFactory {
    private SelectionFactory() {
    }

    public static ISelection createEmptySelection() {
        return new EmptySelection();
    }

    public static ISelection createOneKeySelection(Object[] key) {
        return new OneKeySelection(key);
    }

    public static ISelection createMutiKeySelection(Object[][] keys) {
        return new MultiKeySelection(keys);
    }

    public static ISelection[] createSelectionArray(Object[][] keys) {
        ISelection[] result = new ISelection[keys.length];
        int i = 0;
        while (i < keys.length) {
            result[i] = new OneKeySelection(keys[i]);
            ++i;
        }
        return result;
    }

    public static ISelection createRangeSelection(Object[] minKey, Object[] maxKey, boolean containsMinKey, boolean containsMaxKey) {
        return new RangeSelection(minKey, maxKey, containsMinKey, containsMaxKey);
    }
}

