package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create;

/*
 * #%L
 * Tutti :: UI
 * $Id: CreateMarineLitterBatchUIHandler.java 1564 2014-01-31 10:56:26Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.2.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/marinelitter/create/CreateMarineLitterBatchUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import org.nuiton.jaxx.application.swing.util.Cancelable;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComponent;
import java.awt.Dimension;
import java.util.List;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class CreateMarineLitterBatchUIHandler extends AbstractTuttiUIHandler<CreateMarineLitterBatchUIModel, CreateMarineLitterBatchUI> implements Cancelable {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(CreateMarineLitterBatchUIHandler.class);

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInit(CreateMarineLitterBatchUI ui) {
        super.beforeInit(ui);
        CreateMarineLitterBatchUIModel model = new CreateMarineLitterBatchUIModel();
        ui.setContextValue(model);
        listModelIsModify(model);
    }

    @Override
    public void afterInit(CreateMarineLitterBatchUI ui) {

        initUI(ui);

        Caracteristic marineLitterCategoryCaracteristic =
                getPersistenceService().getMarineLitterCategoryCaracteristic();
        initBeanFilterableComboBox(ui.getMarineLitterCategoryComboBox(),
                                   Lists.newArrayList(marineLitterCategoryCaracteristic.getQualitativeValue()),
                                   null);

        Caracteristic marineLitterSizeCategoryCaracteristic =
                getPersistenceService().getMarineLitterSizeCategoryCaracteristic();

        initBeanFilterableComboBox(ui.getMarineLitterSizeCategoryComboBox(),
                                   Lists.newArrayList(marineLitterSizeCategoryCaracteristic.getQualitativeValue()),
                                   null);

        listenValidatorValid(ui.getValidator(), getModel());
    }

    @Override
    protected JComponent getComponentToFocus() {
        return getUI().getMarineLitterCategoryComboBox();
    }

    @Override
    public void onCloseUI() {

        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }

        // evict model from validator
        ui.getValidator().setBean(null);

        // when canceling always invalid model
        getModel().setValid(false);

        EditCatchesUI parent = getParentContainer(EditCatchesUI.class);
        parent.getHandler().setMarineLitterSelectedCard(EditCatchesUIHandler.MAIN_CARD);
    }

    @Override
    public SwingValidator<CreateMarineLitterBatchUIModel> getValidator() {
        return ui.getValidator();
    }

    //------------------------------------------------------------------------//
    //-- Cancelable methods                                                 --//
    //------------------------------------------------------------------------//

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug("Cancel UI " + ui);
        }
        closeUI(ui);
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public void openUI(MarineLitterBatchUIModel batchModel) {

        CreateMarineLitterBatchUIModel model = getModel();

        // connect model to validator
        ui.getValidator().setBean(model);

        model.reset();

        Multimap<CaracteristicQualitativeValue, CaracteristicQualitativeValue> categoryUsed =
                model.getMarineLitterCategoryUsed();
        categoryUsed.clear();

        if (batchModel != null) {
            categoryUsed.putAll(batchModel.getMarineLitterCategoriesUsed());
        }

    }

    public void saveAndContinue() {

        if (log.isDebugEnabled()) {
            log.debug("Save And Continue UI " + ui);
        }

        EditCatchesUI parent = getParentContainer(EditCatchesUI.class);
        MarineLitterBatchUI marineLitterTabContent = parent.getMarineLitterTabContent();
        marineLitterTabContent.getHandler().addBatch(getModel());

        // reopen this ui
        openUI(marineLitterTabContent.getModel());
    }

    public void saveAndClose() {

        if (log.isDebugEnabled()) {
            log.debug("Save And Close UI " + ui);
        }

        EditCatchesUI parent = getParentContainer(EditCatchesUI.class);
        parent.getMarineLitterTabContent().getHandler().addBatch(getModel());

        // close dialog
        closeUI(ui);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(ui);
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);

        openDialog(dialogContent, title, new Dimension(400, 130));

        Species result = model.getSelectedSpecies();
        return result;
    }

}
