package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: GenerateReportAction.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.2.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/GenerateReportAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.report.ReportModel;
import fr.ifremer.tutti.ui.swing.content.report.ReportUI;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIHandler;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIModel;

import static org.nuiton.i18n.I18n.t;

/**
 * To generate the selected report.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.9
 */
public class GenerateReportAction extends AbstractTuttiAction<ReportUIModel, ReportUI, ReportUIHandler> {

    public GenerateReportAction(ReportUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();

        if (doAction) {

            // ask user to confirm overwrite if required
            doAction = askOverwriteFile(getModel().getOutputFile());
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkState(getModel().isValid());

        ProgressionModel progressionModel = new ProgressionModel();
        setProgressionModel(progressionModel);
        progressionModel.setTotal(4); // get data / export / generate
        ReportModel reportModel = getModel().toBean();
        getContext().getReportService().generateReport(
                reportModel, progressionModel);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        sendMessage(t("tutti.report.generated", getModel().getOutputFile()));

        getModel().reloadOuputFile();
    }
}
