/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatReferentialImportResult;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryPersonService;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporaryPerson;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportReferentialPersonAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportReferentialPersonAction.class);
    private final ReferentialTemporaryPersonService referentialTemporaryPersonService;

    public ImportReferentialPersonAction(GenericFormatImportContext importContext, ReferentialTemporaryPersonService referentialTemporaryPersonService) {
        super(importContext);
        this.referentialTemporaryPersonService = referentialTemporaryPersonService;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.getReferentialTemporaryPersonFileResult().isFound();
    }

    @Override
    protected void doExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.temporaryPersons", (Object[])new Object[0]));
        if (log.isInfoEnabled()) {
            log.info((Object)"Import temporary persons.");
        }
        GenericFormatReferentialImportResult<Person, Integer> importFileResult = this.importContext.getReferentialTemporaryPersonFileResult();
        ReferentialImportRequest<Person, Integer> referentialImportRequest = this.referentialTemporaryPersonService.createReferentialImportRequest();
        try (CsvConsumerForTemporaryPerson consumer = this.importContext.loadTemporaryPersons(false);){
            for (ImportRow row : consumer) {
                consumer.checkRowForGenericFormatImport(row, referentialImportRequest);
            }
            importFileResult.flushErrors(consumer);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close person.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        if (importFileResult.isValid()) {
            ReferentialImportResult<Person> referentialImportResult = this.referentialTemporaryPersonService.executeImportRequest(referentialImportRequest);
            importFileResult.flushResult(referentialImportRequest, referentialImportResult);
            if (log.isInfoEnabled()) {
                log.info((Object)("Temporary persons import result: " + importFileResult.getReport()));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Do not import temporary persons (the incoming file is not valid)");
        }
    }

    @Override
    protected void skipExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Skip import temporary persons (no file found).");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.temporaryPersons", (Object[])new Object[0]));
    }
}

