/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersitenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForMarineLitter;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportMarineLitterAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportMarineLitterAction.class);
    private final GenericformatImportPersitenceHelper persitenceHelper;

    public ImportMarineLitterAction(GenericFormatImportContext importContext, GenericformatImportPersitenceHelper persitenceHelper) {
        super(importContext);
        this.persitenceHelper = persitenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getSurveyFileResult().isValid() && this.importContext.getOperationFileResult().isValid();
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import marineLitter.csv file.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.marineLitters", (Object[])new Object[0]));
        GenericFormatCsvFileResult importFileResult = this.importContext.getMarineLitterFileResult();
        try (CsvConsumerForMarineLitter consumer = this.importContext.loadMarineLitters(true);){
            for (ImportRow row : consumer) {
                GenericFormatImportOperationContext operationContext = consumer.validateRow(row, this.importContext);
                consumer.prepareRowForPersist(operationContext, row);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close marineLitter.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        this.persitenceHelper.persistMarineLitterBatches();
    }
}

