/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.consumer;

import com.google.common.base.Predicate;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchs;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatchs;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.CatchModel;
import fr.ifremer.tutti.service.genericformat.csv.CatchRow;
import fr.ifremer.tutti.service.genericformat.csv.ExportSampleCategory;
import java.nio.file.Path;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;

public class CsvConsumerForCatch
extends CsvComsumer<CatchRow, CatchModel> {
    private static final Log log = LogFactory.getLog(CsvConsumerForCatch.class);
    private final Predicate<CatchRow> catchRowVracPredicate = new Predicate<CatchRow>(){

        public boolean apply(CatchRow input) {
            ExportSampleCategory exportSampleCategory = input.getSampleCategory().get(0);
            return QualitativeValueId.SORTED_VRAC.getValue().equals(((CaracteristicQualitativeValue)exportSampleCategory.getCategoryValue()).getIdAsInt());
        }
    };
    private int batchId;

    public CsvConsumerForCatch(Path file, char separator, SampleCategoryModel sampleCategoryModel, GenericFormatImportEntityParserFactory parserFactory, boolean reportError) {
        super(file, CatchModel.forImport(separator, sampleCategoryModel, parserFactory), reportError);
    }

    public GenericFormatImportOperationContext validateRow(ImportRow<CatchRow> row, GenericFormatImportContext importContext) {
        GenericFormatImportOperationContext operationContext = null;
        if (row.isValid() && (operationContext = importContext.getValidationHelper().getFishingOperationContext(this, row, importContext)) != null) {
            CatchRow bean = (CatchRow)row.getBean();
            for (ExportSampleCategory sampleCategory : bean.getSampleCategory()) {
                if (sampleCategory.isFilled() && sampleCategory.getCategoryValue() != null) continue;
            }
        }
        this.reportError(row);
        return operationContext;
    }

    public void prepareRowForPersist(GenericFormatImportOperationContext operationContext, ImportRow<CatchRow> row) {
        CatchRow bean = (CatchRow)row.getBean();
        boolean vrac = this.catchRowVracPredicate.apply((Object)bean);
        bean.setVrac(vrac);
        boolean withFrequency = bean.withFrequency();
        if (!withFrequency && BooleanUtils.toBooleanDefaultIfNull((Boolean)bean.getBatchNumberComputed(), (boolean)false)) {
            bean.setBatchNumber(null);
        }
        if (bean.isBenthos()) {
            this.prepareBenthosRowForPersist(operationContext, bean, withFrequency);
        } else {
            this.prepareSpeciesRowForPersist(operationContext, bean, withFrequency);
        }
    }

    protected void prepareSpeciesRowForPersist(GenericFormatImportOperationContext operationContext, CatchRow bean, boolean withFrequency) {
        Species species = bean.getSpecies();
        boolean vrac = bean.isVrac();
        SpeciesBatch batch = operationContext.getSpeciesBatch(vrac, species.getReferenceTaxonId());
        if (batch == null) {
            batch = SpeciesBatchs.newSpeciesBatch();
            batch.setId(Integer.valueOf(this.getNextBatchId()));
            batch.setSpecies(species);
            batch.setFishingOperation(operationContext.getFishingOperation());
            if (log.isInfoEnabled()) {
                log.info((Object)("Create species root batch (" + (vrac ? "VRAC" : "HORS VRAC") + ") batch species: " + species.getName() + " for " + operationContext.getFishingOperationLabel()));
            }
            operationContext.addSpeciesBatch(vrac, batch);
        }
        batch = this.fillBatchCategories(batch, bean);
        if (withFrequency) {
            SpeciesBatchFrequency frequency = SpeciesBatchFrequencys.newSpeciesBatchFrequency();
            frequency.setBatch(batch);
            frequency.setLengthStepCaracteristic(bean.getFrequencyLengthStepCaracteristic());
            frequency.setLengthStep(bean.getFrequencyLengthStep());
            frequency.setWeight(bean.getFrequencyWeight());
            frequency.setNumber(bean.getBatchNumber());
            if (log.isInfoEnabled()) {
                log.info((Object)("Create species frequency " + frequency.getNumber() + " for batch: " + batch.getSpecies().getName() + " - " + batch.getSampleCategoryId() + " - " + batch.getSampleCategoryValue()));
            }
            operationContext.addSpeciesFrequency(batch, frequency);
        } else {
            batch.setNumber(bean.getBatchNumber());
        }
    }

    protected void prepareBenthosRowForPersist(GenericFormatImportOperationContext operationContext, CatchRow bean, boolean withFrequency) {
        Species species = bean.getSpecies();
        boolean vrac = bean.isVrac();
        BenthosBatch batch = operationContext.getBenthosBatch(vrac, species.getReferenceTaxonId());
        if (batch == null) {
            batch = BenthosBatchs.newBenthosBatch();
            batch.setId(Integer.valueOf(this.getNextBatchId()));
            batch.setSpecies(species);
            batch.setFishingOperation(operationContext.getFishingOperation());
            if (log.isInfoEnabled()) {
                log.info((Object)("Create benthos root batch (" + (vrac ? "VRAC" : "HORS VRAC") + ") batch species: " + species.getName() + " for " + operationContext.getFishingOperationLabel()));
            }
            operationContext.addBenthosBatch(vrac, batch);
        }
        batch = this.fillBatchCategories(batch, bean);
        if (withFrequency) {
            BenthosBatchFrequency frequency = BenthosBatchFrequencys.newBenthosBatchFrequency();
            frequency.setBatch(batch);
            frequency.setLengthStepCaracteristic(bean.getFrequencyLengthStepCaracteristic());
            frequency.setLengthStep(bean.getFrequencyLengthStep());
            frequency.setWeight(bean.getFrequencyWeight());
            frequency.setNumber(bean.getBatchNumber());
            if (log.isInfoEnabled()) {
                log.info((Object)("Create benthos frequency " + frequency.getNumber() + " for batch: " + batch.getSpecies().getName() + " - " + batch.getSampleCategoryId() + " - " + batch.getSampleCategoryValue()));
            }
            operationContext.addBenthosFrequency(batch, frequency);
        } else {
            batch.setNumber(bean.getBatchNumber());
        }
    }

    protected <A extends SpeciesAbleBatch> A fillBatchCategories(A batch, CatchRow bean) {
        for (ExportSampleCategory exportSampleCategory : bean.getFilledSampleCategories()) {
            batch = this.fillBatchCategories(batch, exportSampleCategory);
        }
        return batch;
    }

    protected <A extends SpeciesAbleBatch> A fillBatchCategories(A batch, ExportSampleCategory sampleCategory) {
        SpeciesAbleBatch result = null;
        if (batch.getSampleCategoryId() == null) {
            batch.setSampleCategoryId(sampleCategory.getCategoryId());
            batch.setSampleCategoryValue(sampleCategory.getCategoryValue());
            batch.setSampleCategoryWeight(sampleCategory.getCategoryWeight());
            result = batch;
        } else {
            if (batch.getSampleCategoryId().equals(sampleCategory.getCategoryId()) && batch.getSampleCategoryValue().equals(sampleCategory.getCategoryValue())) {
                result = batch;
            } else if (!batch.isChildBatchsEmpty()) {
                for (SpeciesAbleBatch childBatch : SpeciesAbleBatchs.getChildBatchs(batch)) {
                    if (!childBatch.getSampleCategoryId().equals(sampleCategory.getCategoryId()) || !childBatch.getSampleCategoryValue().equals(sampleCategory.getCategoryValue())) continue;
                    result = childBatch;
                    break;
                }
            }
            if (result == null) {
                result = SpeciesAbleBatchs.createNewChild(batch);
                result.setId(Integer.valueOf(this.getNextBatchId()));
                result.setSampleCategoryId(sampleCategory.getCategoryId());
                result.setSampleCategoryValue(sampleCategory.getCategoryValue());
                result.setSampleCategoryWeight(sampleCategory.getCategoryWeight());
                if (log.isInfoEnabled()) {
                    log.info((Object)("Create child batch for batch: " + batch.getSpecies().getName() + " - " + batch.getSampleCategoryId() + " - " + batch.getSampleCategoryValue()));
                }
            }
        }
        return (A)result;
    }

    private int getNextBatchId() {
        return this.batchId++;
    }
}

