/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;

public class ParamBinding
extends Structure {
    public static final String PARAM_BINDING_STRUCT = "ParamBinding";
    public static final String PARAM_NAME_MEMBER = "paramName";
    public static final String EXPRESSION_MEMBER = "expression";
    private String paramName = null;
    private List<Expression> expressions = null;

    @Override
    public String getStructName() {
        return PARAM_BINDING_STRUCT;
    }

    @Override
    protected Object getIntrinsicProperty(String propName) {
        if (PARAM_NAME_MEMBER.equals(propName)) {
            return this.paramName;
        }
        if (EXPRESSION_MEMBER.equals(propName)) {
            return this.expressions;
        }
        assert (false);
        return null;
    }

    @Override
    protected void setIntrinsicProperty(String propName, Object value) {
        if (PARAM_NAME_MEMBER.equals(propName)) {
            this.paramName = (String)value;
        } else if (EXPRESSION_MEMBER.equals(propName)) {
            this.expressions = (List)value;
        } else assert (false);
    }

    public String getParamName() {
        return (String)this.getProperty(null, PARAM_NAME_MEMBER);
    }

    public void setParamName(String name) {
        this.setProperty(PARAM_NAME_MEMBER, (Object)name);
    }

    public String getExpression() {
        List<Expression> values = this.getExpressionList();
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0).getStringExpression();
    }

    public List<Expression> getExpressionList() {
        return (List)this.getProperty(null, EXPRESSION_MEMBER);
    }

    public void setExpression(String expression) {
        if (expression == null) {
            this.setProperty(EXPRESSION_MEMBER, null);
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(expression);
        this.setProperty(EXPRESSION_MEMBER, values);
    }

    public void setExpression(List<Expression> values) {
        this.setProperty(EXPRESSION_MEMBER, values);
    }

    public List validate(Module module, DesignElement element) {
        ArrayList<PropertyValueException> list = new ArrayList<PropertyValueException>();
        if (StringUtil.isBlank(this.getParamName())) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(PARAM_NAME_MEMBER), (Object)this.getParamName(), "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }

    @Override
    public StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new ParamBindingHandle(valueHandle, index);
    }
}

