/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrException;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.RunningAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalRunningNpv
extends AggrFunction {
    @Override
    public String getName() {
        return "RUNNINGNPV";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("rate", Messages.getString("TotalRunningNpv.param.rate"), true, false, SupportedDataTypes.CALCULATABLE, "")};
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalRunningNpv.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalRunningNpv.displayName");
    }

    private static class MyAccumulator
    extends RunningAccumulator {
        private Object npv = 0.0;
        private double rate = 0.0;
        private int count = 1;

        private MyAccumulator() {
        }

        @Override
        public void start() throws DataException {
            super.start();
            this.npv = 0.0;
            this.count = 1;
        }

        @Override
        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (args[0] != null) {
                if (this.calculator == null) {
                    this.calculator = CalculatorFactory.getCalculator(args[0].getClass());
                }
                try {
                    if (this.count == 1) {
                        this.rate = args[1] != null ? DataTypeUtil.toDouble(args[1]).doubleValue() : DataTypeUtil.toDouble(0).doubleValue();
                    }
                    this.npv = this.calculator.add(this.npv, this.calculator.divide(args[0], Math.pow(1.0 + this.rate, this.count++)));
                }
                catch (BirtException e) {
                    throw DataException.wrap(new AggrException("aggregation.DataConversionError", e));
                }
            }
        }

        @Override
        public Object getValue() {
            return this.count > 1 ? this.npv : null;
        }
    }
}

