/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.csv;

import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.CaracteristicValueParserFormatter;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.csv.CatchRow;
import fr.ifremer.tutti.service.genericformat.csv.ExportSampleCategory;
import org.apache.commons.beanutils.PropertyUtils;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;
import org.nuiton.csv.ValueSetter;

public class CatchModel
extends AbstractTuttiImportExportModel<CatchRow> {
    public static final String WEIGHT_OR_VOL_TYPE = "Poids";

    public static CatchModel forExport(char separator, SampleCategoryModel sampleCategoryModel) {
        CatchModel exportModel = new CatchModel(separator);
        exportModel.forExport(sampleCategoryModel);
        return exportModel;
    }

    public static CatchModel forImport(char separator, SampleCategoryModel sampleCategoryModel, GenericFormatImportEntityParserFactory parserFactory) {
        CatchModel importModel = new CatchModel(separator);
        importModel.forImport(sampleCategoryModel, parserFactory);
        return importModel;
    }

    public CatchRow newEmptyInstance() {
        CatchRow row = CatchRow.newEmptyInstance();
        row.forImport();
        return row;
    }

    protected CatchModel(char separator) {
        super(separator);
    }

    protected void forExport(SampleCategoryModel sampleCategoryModel) {
        String collectionName;
        int categoryOrder;
        String headerPrefix;
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", TuttiCsvUtil.PROGRAM_FORMATTER);
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Code_Station", "stationNumber");
        this.newColumnForExport("Id_Operation", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Code_Taxon", "species", TuttiCsvUtil.SPECIES_TECHNICAL_FORMATTER);
        this.newColumnForExport("Code_Espece_Campagne", "species", TuttiCsvUtil.SPECIES_SURVEY_CODE_FORMATTER);
        this.newColumnForExport("Nom_Scientifique", "species", TuttiCsvUtil.SPECIES_FORMATTER);
        this.newColumnForExport("Benthos", "benthos", (ValueFormatter)TuttiCsvUtil.BOOLEAN);
        this.newColumnForExport("Commentaire", "comment", (ValueFormatter)TuttiCsvUtil.COMMENT_LIST_PARSER_FORMATTER);
        for (SampleCategoryModelEntry entry : sampleCategoryModel.getCategory()) {
            headerPrefix = entry.getCode();
            categoryOrder = entry.getOrder();
            collectionName = "sampleCategory";
            this.newIndexNullableColumnForExport(headerPrefix, collectionName, categoryOrder, "categoryValue", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
            this.newIndexNullableColumnForExport("Num_Ordre_" + headerPrefix + "_H2", collectionName, categoryOrder, "rankOrder", TuttiCsvUtil.INTEGER);
            this.newIndexNullableColumnForExport("Tot_" + headerPrefix, collectionName, categoryOrder, "categoryWeight", TuttiCsvUtil.FLOAT);
            this.newIndexNullableColumnForExport("Ech_" + headerPrefix, collectionName, categoryOrder, "sampleWeight", TuttiCsvUtil.FLOAT);
            this.newIndexNullableColumnForExport("Type_Volume_Poids_" + headerPrefix, collectionName, categoryOrder, "weightOrVolType");
            this.newNullableColumnForExport("Unite_Volume_Poids_" + headerPrefix, "batchWeightUnit");
        }
        this.newColumnForExport("Code_Longueur", "frequencyLengthStepCaracteristic", TuttiCsvUtil.CARACTERISTIC_TECHNICAL_FORMATTER);
        this.newColumnForExport("Libelle_Longueur", "frequencyLengthStepCaracteristic", TuttiCsvUtil.CARACTERISTIC_FORMATTER);
        this.newColumnForExport("Taille", "frequencyLengthStep", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("NumOrdre_Taille_H2", "frequencyRankOrder", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poids_Classe_Taille", "frequencyWeight", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Unite_Taille", "frequencyLengthStepCaracteristic.unit");
        this.newNullableColumnForExport("Precision_Mesure", "frequencyLengthStepCaracteristic.precision", TuttiCsvUtil.FLOAT);
        this.newColumnForExport("Nbr", "batchNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Nbr_Calcule", "batchNumberComputed", (ValueFormatter)TuttiCsvUtil.BOOLEAN);
        this.newColumnForExport("Poids_Reference", "referenceWeight", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
        this.newColumnForExport("Coef_Elev_Espece_Capture", "raisingFactor", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
        this.newColumnForExport("Coef_Final_Elevation", "finalRaisingFactor", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("Serie_Id", "program", TuttiCsvUtil.PROGRAM_TECHNICAL_FORMATTER);
        for (SampleCategoryModelEntry entry : sampleCategoryModel.getCategory()) {
            headerPrefix = entry.getCode();
            categoryOrder = entry.getOrder();
            collectionName = "sampleCategory";
            this.newIndexNullableColumnForExport(headerPrefix + "_Id", collectionName, categoryOrder, "categoryValue", TuttiCsvUtil.CARACTERISTIC_VALUE_TECHNICAL_FORMATTER);
            this.newIndexNullableColumnForExport(headerPrefix + "_Lot_Id", collectionName, categoryOrder, "batchId", TuttiCsvUtil.INTEGER);
        }
    }

    protected void forImport(SampleCategoryModel sampleCategoryModel, GenericFormatImportEntityParserFactory parserFactory) {
        String headerPrefix;
        this.newMandatoryColumn("Annee", "beginDate", (ValueParser)TuttiCsvUtil.YEAR);
        this.newIgnoredColumn("Serie");
        this.newMandatoryColumn("Serie_Partielle", "surveyPart");
        this.newMandatoryColumn("Code_Station", "stationNumber");
        this.newMandatoryColumn("Id_Operation", "fishingOperationNumber", (ValueParser)TuttiCsvUtil.INTEGER);
        this.newMandatoryColumn("Poche", "multirigAggregation");
        this.newMandatoryColumn("Code_Taxon", "species", (ValueParser)parserFactory.getSpeciesParser());
        this.newIgnoredColumn("Code_Espece_Campagne");
        this.newIgnoredColumn("Nom_Scientifique");
        this.newMandatoryColumn("Benthos", "benthos", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newMandatoryColumn("Commentaire", "comment", (ValueParser)TuttiCsvUtil.COMMENT_LIST_PARSER_FORMATTER);
        for (SampleCategoryModelEntry entry : sampleCategoryModel.getCategory()) {
            headerPrefix = entry.getCode();
            this.newIgnoredColumn(headerPrefix);
            this.newMandatoryColumn("Num_Ordre_" + headerPrefix + "_H2", (ValueParser)TuttiCsvUtil.INTEGER, new SampleCategoryValueSetter(entry, "rankOrder"));
            this.newMandatoryColumn("Tot_" + headerPrefix, (ValueParser)TuttiCsvUtil.FLOAT, new SampleCategoryValueSetter(entry, "categoryWeight"));
            this.newMandatoryColumn("Ech_" + headerPrefix, (ValueParser)TuttiCsvUtil.FLOAT, new SampleCategoryValueSetter(entry, "sampleWeight"));
            this.newIgnoredColumn("Type_Volume_Poids_" + headerPrefix);
            this.newIgnoredColumn("Unite_Volume_Poids_" + headerPrefix);
        }
        this.newMandatoryColumn("Code_Longueur", "frequencyLengthStepCaracteristic", (ValueParser)parserFactory.getCaracteristicParser());
        this.newIgnoredColumn("Libelle_Longueur");
        this.newMandatoryColumn("Taille", "frequencyLengthStep", (ValueParser)TuttiCsvUtil.FLOAT);
        this.newMandatoryColumn("NumOrdre_Taille_H2", "frequencyRankOrder", (ValueParser)TuttiCsvUtil.INTEGER);
        this.newMandatoryColumn("Poids_Classe_Taille", "frequencyWeight", (ValueParser)TuttiCsvUtil.FLOAT);
        this.newIgnoredColumn("Unite_Taille");
        this.newIgnoredColumn("Precision_Mesure");
        this.newMandatoryColumn("Nbr", "batchNumber", (ValueParser)TuttiCsvUtil.INTEGER);
        this.newMandatoryColumn("Nbr_Calcule", "batchNumberComputed", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newIgnoredColumn("Poids_Reference");
        this.newIgnoredColumn("Coef_Elev_Espece_Capture");
        this.newIgnoredColumn("Coef_Final_Elevation");
        this.newMandatoryColumn("Serie_Id", "program", (ValueParser)parserFactory.getProgramParser());
        for (SampleCategoryModelEntry entry : sampleCategoryModel.getCategory()) {
            headerPrefix = entry.getCode();
            this.newMandatoryColumn(headerPrefix + "_Id", (ValueParser)CaracteristicValueParserFormatter.newParser(entry.getCaracteristic()), new SampleCategoryValueSetter(entry, "categoryValue"));
            this.newMandatoryColumn(headerPrefix + "_Lot_Id", (ValueParser)TuttiCsvUtil.INTEGER, new SampleCategoryValueSetter(entry, "batchId"));
        }
    }

    private static class SampleCategoryValueSetter<O>
    implements ValueSetter<CatchRow, O> {
        private final SampleCategoryModelEntry sampleCategoryModelEntry;
        private final String propertyName;

        public SampleCategoryValueSetter(SampleCategoryModelEntry sampleCategoryModelEntry, String propertyName) {
            this.sampleCategoryModelEntry = sampleCategoryModelEntry;
            this.propertyName = propertyName;
        }

        public void set(CatchRow row, O value) throws Exception {
            ExportSampleCategory sampleCategory = row.getSampleCategory(this.sampleCategoryModelEntry);
            PropertyUtils.setProperty((Object)((Object)sampleCategory), (String)this.propertyName, value);
        }
    }
}

