/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchive;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportActionEngine;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportConfiguration;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportRequest;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportResult;
import fr.ifremer.tutti.service.genericformat.csv.SampleCategoryModel;
import fr.ifremer.tutti.service.genericformat.csv.SampleCategoryRow;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForSampleCategory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class GenericFormatExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(GenericFormatExportService.class);
    private PersistenceService persistenceService;
    private WeightComputingService weightComputingService;
    private GenericFormatExportActionEngine actionEngine;
    private Decorator<FishingOperation> fishingOperationDecorator;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.weightComputingService = this.getService(WeightComputingService.class);
        this.actionEngine = new GenericFormatExportActionEngine(context);
        DecoratorService decoratorService = this.getService(DecoratorService.class);
        this.fishingOperationDecorator = decoratorService.getDecoratorByType(FishingOperation.class);
    }

    public GenericFormatExportConfiguration createExportConfigurationForProgram(String programId, File exportFile) {
        ProgramDataModel dataToExport = this.persistenceService.loadProgram(programId, true);
        GenericFormatExportConfiguration configuration = new GenericFormatExportConfiguration();
        configuration.setExportFile(exportFile);
        configuration.setExportAttachments(true);
        configuration.setExportSpecies(true);
        configuration.setExportBenthos(true);
        configuration.setExportMarineLitter(true);
        configuration.setExportAccidentalCatch(true);
        configuration.setExportIndividualObservation(true);
        configuration.setDataToExport(dataToExport);
        return configuration;
    }

    public GenericFormatExportConfiguration createExportConfigurationForCruise(String programId, String cruiseId, File exportFile) {
        Preconditions.checkNotNull((Object)cruiseId);
        Preconditions.checkNotNull((Object)exportFile);
        ProgramDataModel dataToExport = this.persistenceService.loadCruises(programId, true, cruiseId);
        GenericFormatExportConfiguration configuration = new GenericFormatExportConfiguration();
        configuration.setExportFile(exportFile);
        configuration.setExportAttachments(true);
        configuration.setExportSpecies(true);
        configuration.setExportBenthos(true);
        configuration.setExportMarineLitter(true);
        configuration.setExportAccidentalCatch(true);
        configuration.setExportIndividualObservation(true);
        configuration.setDataToExport(dataToExport);
        return configuration;
    }

    public GenericFormatExportConfiguration createExportConfigurationForFishingOperation(String programId, String cruiseId, String fishingOperationId, File exportFile) {
        Preconditions.checkNotNull((Object)programId);
        Preconditions.checkNotNull((Object)cruiseId);
        Preconditions.checkNotNull((Object)fishingOperationId);
        ProgramDataModel dataToExport = this.persistenceService.loadCruise(programId, cruiseId, fishingOperationId);
        GenericFormatExportConfiguration configuration = new GenericFormatExportConfiguration();
        configuration.setExportFile(exportFile);
        configuration.setExportAttachments(true);
        configuration.setExportSpecies(true);
        configuration.setExportBenthos(true);
        configuration.setExportMarineLitter(true);
        configuration.setExportAccidentalCatch(true);
        configuration.setExportIndividualObservation(true);
        configuration.setDataToExport(dataToExport);
        return configuration;
    }

    public int getExportNbSteps(GenericFormatExportConfiguration configuration) {
        ProgramDataModel dataToExport = configuration.getDataToExport();
        int result = 8;
        for (CruiseDataModel cruise : dataToExport) {
            int nbFishingOperations = cruise.size();
            result += this.getCruiseNbStep(nbFishingOperations);
        }
        return result;
    }

    public GenericFormatExportResult export(GenericFormatExportConfiguration configuration, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)progressionModel);
        GenericFormatExportRequest exportRequest = this.createExportRequest(configuration);
        ArrayList<String> errors = new ArrayList<String>();
        try (GenericFormatExportContext exportContext = this.createExportContext(exportRequest, progressionModel);){
            GenericFormatExportResult result;
            this.actionEngine.executeLoadActions(exportContext);
            for (GenericFormatExportCruiseContext cruiseContext : exportContext) {
                Cruise cruise = cruiseContext.getCruise();
                Set<FishingOperation> operations = cruiseContext.getOperations();
                String checkErrors = cruiseContext.getCheckErrors();
                if (checkErrors != null) {
                    errors.add(checkErrors);
                }
                this.exportCruise(exportContext, cruise, operations);
            }
            this.actionEngine.executeTechnicalActions(exportContext);
            GenericFormatExportResult genericFormatExportResult = result = new GenericFormatExportResult(exportRequest, errors);
            return genericFormatExportResult;
        }
    }

    public void exportSampleCategoryModel(File exportFile) {
        ProgressionModel progressionModel = new ProgressionModel();
        progressionModel.setTotal(1000);
        GenericFormatArchive archive = GenericFormatArchive.forExport(null, this.context.getConfig().getTmpDirectory());
        CsvProducerForSampleCategory producerForSampleCategory = new CsvProducerForSampleCategory(archive.getSampleCategoryModelPath(), SampleCategoryModel.forExport(';'));
        List<SampleCategoryRow> dataToExport = producerForSampleCategory.getDataToExport(this.context.getSampleCategoryModel());
        try {
            producerForSampleCategory.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException("Could not export sample category model", (Throwable)e);
        }
        try {
            Files.copy(archive.getSampleCategoryModelPath(), exportFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not copy csv file to export file", (Throwable)e);
        }
    }

    protected GenericFormatExportRequest createExportRequest(GenericFormatExportConfiguration configuration) {
        Path attachmentsSourcePath = this.context.getConfig().getDbAttachmentDirectory().toPath();
        TuttiProtocol tuttiProtocol = this.context.getDataContext().getProtocol();
        GenericFormatArchive archive = GenericFormatArchive.forExport(configuration.getExportFile(), this.context.getConfig().getTmpDirectory());
        GenericFormatExportRequest exportRequest = new GenericFormatExportRequest(configuration, archive, ';', this.context.getSampleCategoryModel(), tuttiProtocol, this.context.getConfig().getExportCountryId(), attachmentsSourcePath);
        return exportRequest;
    }

    protected GenericFormatExportContext createExportContext(GenericFormatExportRequest exportRequest, ProgressionModel progressionModel) {
        return new GenericFormatExportContext(progressionModel, exportRequest, this.persistenceService, this.fishingOperationDecorator);
    }

    protected void exportCruise(GenericFormatExportContext exportContext, Cruise cruise, Set<FishingOperation> operations) {
        this.actionEngine.executeCruiseActions(exportContext, cruise);
        for (FishingOperation operation : operations) {
            GenericFormatExportOperationContext operationContext = exportContext.newOperationContext(this.persistenceService, this.weightComputingService, cruise, operation);
            exportContext.increments(I18n.t((String)"tutti.service.genericFormat.exportCruise.exportOperation", (Object[])new Object[]{cruise.getName(), operationContext.getOperationLabel()}));
            this.actionEngine.executeOperationActions(exportContext, operationContext);
        }
    }

    protected int getCruiseNbStep(int nbFishingOperations) {
        int result = 1 + nbFishingOperations + 1 + 1 + nbFishingOperations;
        return result;
    }
}

