/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.consumer;

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportValidationHelper;
import fr.ifremer.tutti.service.genericformat.consumer.FishingOperationAlreadyImportedException;
import fr.ifremer.tutti.service.genericformat.consumer.FishingOperationNotValidException;
import fr.ifremer.tutti.service.genericformat.csv.OperationModel;
import fr.ifremer.tutti.service.genericformat.csv.OperationRow;
import java.nio.file.Path;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.nuiton.csv.ImportRow;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;

public class CsvConsumerForOperation
extends CsvComsumer<OperationRow, OperationModel> {
    public CsvConsumerForOperation(Path file, char separator, GenericFormatImportEntityParserFactory parserFactory, boolean reportError) {
        super(file, OperationModel.forImport(separator, parserFactory), reportError);
    }

    public GenericFormatImportCruiseContext validateRow(ImportRow<OperationRow> row, GenericFormatContextSupport importContext) {
        GenericFormatImportValidationHelper validationHelper;
        GenericFormatImportCruiseContext cruiseContext = null;
        if (row.isValid() && (cruiseContext = (validationHelper = importContext.getValidationHelper()).getCruise(this, row, importContext)) != null) {
            OperationRow bean = (OperationRow)row.getBean();
            FishingOperation fishingOperation = bean.getFishingOperation();
            if (cruiseContext.isFishingOperationAlreadyImported(bean)) {
                this.addCheckError(row, new FishingOperationAlreadyImportedException(fishingOperation));
            } else {
                NuitonValidatorResult validatorResult;
                Gear cruiseGear;
                Gear gear = bean.getGear();
                Short rankOrder = bean.getGearRankOrder();
                if (gear != null && rankOrder != null && (cruiseGear = validationHelper.getGear(this, importContext, row, gear, rankOrder)) != null) {
                    bean.setGear(cruiseGear);
                }
                if ((validatorResult = validationHelper.validateFishingOperation(fishingOperation)).hasFatalMessages()) {
                    Set<String> errorMessages = validationHelper.getMessages(validatorResult, NuitonValidatorScope.FATAL);
                    this.addCheckError(row, new FishingOperationNotValidException(fishingOperation, errorMessages));
                }
            }
        }
        this.reportError(row);
        return cruiseContext;
    }

    public void prepareRowForPersist(GenericFormatImportCruiseContext cruiseContext, ImportRow<OperationRow> row) {
        OperationRow bean = (OperationRow)row.getBean();
        CatchBatch catchBatch = bean.getCatchBatch();
        if (BooleanUtils.toBooleanDefaultIfNull((Boolean)bean.getCatchTotalWeightComputed(), (boolean)false)) {
            catchBatch.setCatchTotalWeight(null);
        }
        if (BooleanUtils.toBooleanDefaultIfNull((Boolean)bean.getCatchTotalRejectedWeightComputed(), (boolean)false)) {
            catchBatch.setCatchTotalRejectedWeight(null);
        }
        if (BooleanUtils.toBooleanDefaultIfNull((Boolean)bean.getSpeciesTotalSortedWeightComputed(), (boolean)false)) {
            catchBatch.setSpeciesTotalSortedWeight(null);
        }
        if (BooleanUtils.toBooleanDefaultIfNull((Boolean)bean.getSpeciesTotalInertWeightComputed(), (boolean)false)) {
            catchBatch.setSpeciesTotalInertWeight(null);
        }
        if (BooleanUtils.toBooleanDefaultIfNull((Boolean)bean.getSpeciesTotalLivingNotItemizedWeightComputed(), (boolean)false)) {
            catchBatch.setSpeciesTotalLivingNotItemizedWeight(null);
        }
        if (BooleanUtils.toBooleanDefaultIfNull((Boolean)bean.getBenthosTotalSortedWeightComputed(), (boolean)false)) {
            catchBatch.setBenthosTotalSortedWeight(null);
        }
        if (BooleanUtils.toBooleanDefaultIfNull((Boolean)bean.getBenthosTotalInertWeightComputed(), (boolean)false)) {
            catchBatch.setBenthosTotalInertWeight(null);
        }
        if (BooleanUtils.toBooleanDefaultIfNull((Boolean)bean.getBenthosTotalLivingNotItemizedWeightComputed(), (boolean)false)) {
            catchBatch.setBenthosTotalLivingNotItemizedWeight(null);
        }
        if (BooleanUtils.toBooleanDefaultIfNull((Boolean)bean.getMarineLitterTotalWeightComputed(), (boolean)false)) {
            catchBatch.setMarineLitterTotalWeight(null);
        }
    }
}

