package fr.ifremer.tutti.ui.swing.content.home.actions;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportConfiguration;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportService;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationBusinessException;

import java.io.File;

import static org.nuiton.i18n.I18n.t;

/**
 * Created on 2/11/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.14
 */
public class ImportGenericFormatProgramCruisesAction extends LongActionSupport<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(ImportGenericFormatProgramCruisesAction.class);

    protected File file;

    public ImportGenericFormatProgramCruisesAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            // choose file to import
            file = chooseFile(
                    t("tutti.selectCruise.title.choose.importGenericFormatFile"),
                    t("tutti.selectCruise.action.importGenericformat"),
                    "^.+\\.zip$", t("tutti.common.file.zip")
            );

            doAction = file != null;
        }

        if (doAction) {

            // compute number of steps (will also check archive format)

            GenericFormatImportConfiguration importConfiguration = new GenericFormatImportConfiguration();
            importConfiguration.setImportFile(file);

            GenericFormatImportService service = getContext().getGenericFormatImportService();
            int nbSteps = service.getImportProgramNbSteps(importConfiguration);
            createProgressionModelIfRequired(nbSteps);

        }

        return doAction;

    }

    @Override
    public void doAction() throws Exception {

        Program program = getModel().getProgram();
        Preconditions.checkNotNull(program);
        Preconditions.checkNotNull(file);

        if (log.isInfoEnabled()) {
            log.info("Will import cruises to program " + program.getName() + " from archive: " + file);
        }

        GenericFormatImportService service = getContext().getGenericFormatImportService();

        ApplicationBusinessException importError = null;

        GenericFormatImportConfiguration importConfiguration = new GenericFormatImportConfiguration();
        importConfiguration.setImportFile(file);
        importConfiguration.setProgramId(program.getId());

        try {
            service.importProgram(importConfiguration, getProgressionModel());
        } catch (ApplicationBusinessException e) {

            String errorMessage;
            errorMessage = t("tutti.importProgram.action.importErrors", program.getName(), e.getMessage());

            importError = new ApplicationBusinessException(errorMessage);
        }

        handler.resetEditProgramAction();

        sendMessage(t("tutti.importProgram.action.success", program.getName(), file.getName()));

        if (importError != null) {
            throw importError;
        }
    }

    @Override
    public void releaseAction() {
        file = null;
        super.releaseAction();
    }
}

