/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.supplier.database;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class JDBCDriverClassLoader
extends URLClassLoader {
    public JDBCDriverClassLoader() {
        super(JDBCDriverClassLoader.getDriverClasspath());
    }

    private static URL[] getDriverClasspath() {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            JDBCDriverClassLoader.addUrlsFromPath(urls, "drivers");
            return urls.toArray(new URL[urls.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addUrlsFromPath(List<URL> addTo, String path) throws Exception {
        File jdbcLib = null;
        try {
            URL url = JDBCDriverClassLoader.class.getClassLoader().getResource(path);
            if (url == null) {
                System.out.println("Null URL for " + path);
                return;
            }
            jdbcLib = new File(url.toURI());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (!jdbcLib.exists()) {
            throw new RuntimeException("JDBC driver directory " + jdbcLib.getAbsolutePath() + " does not exist");
        }
        File[] files = jdbcLib.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (files == null) {
            files = new File[]{};
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File[] driverJars;
            File driverDir = fileArray[n2];
            File[] fileArray2 = driverJars = driverDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("jar");
                }
            });
            int n3 = driverJars.length;
            int n4 = 0;
            while (n4 < n3) {
                File jar = fileArray2[n4];
                addTo.add(jar.toURL());
                ++n4;
            }
            ++n2;
        }
    }
}

