/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.List;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.IncrementalUpdateRowFilter;
import org.eclipse.birt.data.engine.impl.IFilterByRow;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class NoUpdateFilterByRow
implements IFilterByRow {
    private IncrementalUpdateRowFilter rowFilter;
    private IFilterByRow filterByRow;
    private boolean updateGroupInfo;

    public NoUpdateFilterByRow(IFilterByRow filterByRow, ResultSetPopulator populator) throws DataException {
        this.filterByRow = filterByRow;
        this.filterByRow.setWorkingFilterSet(8);
        this.rowFilter = new IncrementalUpdateRowFilter(populator);
    }

    @Override
    public boolean process(IResultObject row, int rowIndex) throws DataException {
        boolean accepted = this.filterByRow.process(row, rowIndex);
        if (this.updateGroupInfo) {
            if (accepted) {
                this.rowFilter.onGroup(rowIndex);
            } else {
                this.rowFilter.notOnGroup(rowIndex);
            }
        }
        return accepted;
    }

    public void setUpdateGroupInfo(boolean updateGroup) {
        this.updateGroupInfo = updateGroup;
    }

    @Override
    public void close() throws DataException {
        this.filterByRow.setWorkingFilterSet(4);
        this.filterByRow.close();
        this.filterByRow = null;
        this.rowFilter.close();
        this.rowFilter = null;
    }

    @Override
    public List<IFilterDefinition> getFilterList() throws DataException {
        return this.filterByRow.getFilterList();
    }

    @Override
    public void setWorkingFilterSet(int filterSetType) throws DataException {
        this.filterByRow.setWorkingFilterSet(filterSetType);
    }
}

