/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.type.ProgressionModel;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SynchroResult {
    protected Exception error;
    protected final Map<String, Integer> rowHits = Maps.newTreeMap();
    protected final Map<String, Integer> insertHits = Maps.newTreeMap();
    protected final Map<String, Integer> updateHits = Maps.newTreeMap();
    protected final Map<String, Integer> deletesHits = Maps.newTreeMap();
    protected final Map<String, Timestamp> updateDateHits = Maps.newTreeMap();
    protected final Map<String, String> rejectedRows = Maps.newTreeMap();
    protected final Map<String, Map<String, Map<String, Object>>> sourceMissingUpdates = Maps.newIdentityHashMap();
    protected final Multimap<String, String> sourceMissingReverts = ArrayListMultimap.create();
    protected final Multimap<String, String> sourceMissingDeletes = ArrayListMultimap.create();
    protected final Set<String> tableNames = Sets.newHashSet();
    protected String targetUrl;
    protected String sourceUrl;
    protected final transient ProgressionModel progressionModel = new ProgressionModel(this);

    public SynchroResult() {
    }

    public SynchroResult(String targetUrl, String sourceUrl) {
        this.targetUrl = targetUrl;
        this.sourceUrl = sourceUrl;
    }

    public void setLocalUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public void setRemoteUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public ProgressionModel getProgressionModel() {
        return this.progressionModel;
    }

    public Set<String> getTableNames() {
        return ImmutableSet.copyOf(this.tableNames);
    }

    public int getTotalRows() {
        int result = 0;
        for (Integer nb : this.rowHits.values()) {
            result += nb.intValue();
        }
        return result;
    }

    public int getTotalInserts() {
        int result = 0;
        for (Integer nb : this.insertHits.values()) {
            result += nb.intValue();
        }
        return result;
    }

    public int getTotalUpdates() {
        int result = 0;
        for (Integer nb : this.updateHits.values()) {
            result += nb.intValue();
        }
        return result;
    }

    public int getTotalDeletes() {
        int result = 0;
        for (Integer nb : this.deletesHits.values()) {
            result += nb.intValue();
        }
        return result;
    }

    public int getTotalRejects() {
        int result = 0;
        for (String rows : this.rejectedRows.values()) {
            result += StringUtils.countMatches((CharSequence)rows, (CharSequence)"\n");
        }
        return result;
    }

    public int getTotalTreated() {
        return this.getTotalInserts() + this.getTotalUpdates() + this.getTotalDeletes() + this.getTotalRejects();
    }

    public int getNbRows(String tableName) {
        Integer result = this.rowHits.get(tableName);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public int getNbInserts(String tableName) {
        Integer result = this.insertHits.get(tableName);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public int getNbUpdates(String tableName) {
        Integer result = this.updateHits.get(tableName);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public int getNbDeletes(String tableName) {
        Integer result = this.deletesHits.get(tableName);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public String getRejectedRows(String tableName) {
        String result = this.rejectedRows.get(tableName);
        if (result == null) {
            return "";
        }
        return result;
    }

    public void addRows(String tableName, int nb) {
        if (nb > 0) {
            this.rowHits.put(tableName, this.getNbRows(tableName) + nb);
        }
    }

    public void addUpdates(String tableName, int nb) {
        if (nb > 0) {
            this.updateHits.put(tableName, this.getNbUpdates(tableName) + nb);
        }
    }

    public void addInserts(String tableName, int nb) {
        if (nb > 0) {
            this.insertHits.put(tableName, this.getNbInserts(tableName) + nb);
        }
    }

    public void addDeletes(String tableName, int nb) {
        if (nb > 0) {
            this.deletesHits.put(tableName, this.getNbDeletes(tableName) + nb);
        }
    }

    public void addReject(String tableName, String ... rowInfo) {
        StringBuilder rows = new StringBuilder(this.getRejectedRows(tableName));
        this.rejectedRows.put(tableName, Joiner.on((char)';').appendTo(rows, (Object[])rowInfo).append('\n').toString());
    }

    public void addSourceMissingColumnUpdate(String tableName, String columnName, List<Object> pk, Object columnValue) {
        Object oldValue;
        String pkStr;
        Map destRows;
        HashMap tableMissingSourceUpdates = this.sourceMissingUpdates.get(tableName);
        if (tableMissingSourceUpdates == null) {
            tableMissingSourceUpdates = Maps.newHashMap();
            this.sourceMissingUpdates.put(tableName, tableMissingSourceUpdates);
        }
        if ((destRows = (Map)tableMissingSourceUpdates.get(columnName)) == null) {
            destRows = Maps.newHashMap();
            tableMissingSourceUpdates.put(columnName, destRows);
        }
        if (destRows.containsKey(pkStr = SynchroTableMetadata.toPkStr(pk)) && !Objects.equal(oldValue = destRows.get(pkStr), (Object)columnValue)) {
            throw new SynchroTechnicalException(String.format("Could not update a row column twice, with two differents values: table [%s] pk [%s] - existing %s: [%s] new: [%s]", tableName, pkStr, columnName, oldValue, columnValue));
        }
        destRows.put(pkStr, columnValue);
    }

    public Timestamp getUpdateDate(String tableName) {
        return this.updateDateHits.get(tableName);
    }

    public void setUpdateDate(String tableName, Timestamp t) {
        this.updateDateHits.put(tableName, t);
    }

    public Map<String, Timestamp> getUpdateDateHits() {
        return this.updateDateHits;
    }

    public Map<String, String> getRejectedRows() {
        return this.rejectedRows;
    }

    public Map<String, Map<String, Map<String, Object>>> getSourceMissingUpdates() {
        return this.sourceMissingUpdates;
    }

    public void addTableName(String tableName) {
        this.tableNames.add(tableName);
    }

    public String getLocalUrl() {
        return this.targetUrl;
    }

    public String getRemoteUrl() {
        return this.sourceUrl;
    }

    public void addSourceMissingRevert(String tableName, String pkStr) {
        this.sourceMissingReverts.put((Object)tableName, (Object)pkStr);
    }

    public Multimap<String, String> getSourceMissingReverts() {
        return this.sourceMissingReverts;
    }

    public void addSourceMissingDelete(String tableName, String pkStr) {
        this.sourceMissingDeletes.put((Object)tableName, (Object)pkStr);
    }

    public Multimap<String, String> getSourceMissingDeletes() {
        return this.sourceMissingDeletes;
    }

    public void clear() {
        this.rowHits.clear();
        this.insertHits.clear();
        this.updateHits.clear();
        this.deletesHits.clear();
        this.updateDateHits.clear();
        this.rejectedRows.clear();
        this.sourceMissingUpdates.clear();
        this.sourceMissingReverts.clear();
        this.sourceMissingDeletes.clear();
    }
}

