/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import org.hibernate.BasicQueryContract;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionImplementor;

public abstract class AbstractBasicQueryContractImpl
implements BasicQueryContract {
    private final SessionImplementor session;
    private FlushMode flushMode;
    private CacheMode cacheMode;
    private boolean cacheable;
    private String cacheRegion;
    private boolean readOnly;
    private RowSelection selection = new RowSelection();

    protected AbstractBasicQueryContractImpl(SessionImplementor session) {
        this.session = session;
        this.readOnly = session.getPersistenceContext().isDefaultReadOnly();
    }

    protected SessionImplementor session() {
        return this.session;
    }

    @Override
    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    @Override
    public BasicQueryContract setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    @Override
    public BasicQueryContract setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public BasicQueryContract setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    @Override
    public String getCacheRegion() {
        return this.cacheRegion;
    }

    @Override
    public BasicQueryContract setCacheRegion(String cacheRegion) {
        if (cacheRegion != null) {
            this.cacheRegion = cacheRegion.trim();
        }
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public BasicQueryContract setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public Integer getTimeout() {
        return this.selection.getTimeout();
    }

    @Override
    public BasicQueryContract setTimeout(int timeout) {
        this.selection.setTimeout(timeout);
        return this;
    }

    @Override
    public Integer getFetchSize() {
        return this.selection.getFetchSize();
    }

    @Override
    public BasicQueryContract setFetchSize(int fetchSize) {
        this.selection.setFetchSize(fetchSize);
        return this;
    }

    public QueryParameters buildQueryParametersObject() {
        QueryParameters qp = new QueryParameters();
        qp.setRowSelection(this.selection);
        qp.setCacheable(this.cacheable);
        qp.setCacheRegion(this.cacheRegion);
        qp.setReadOnly(this.readOnly);
        return qp;
    }
}

