// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringDao.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.observedLocation;

import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.andromda.spring.PaginationResult;

/**
 * Lieu observé (ex: un site de débarquement, etc.).
 * An observed location (i.e. a landing site).
 * @see ObservedLocation
 */
public interface ObservedLocationDao
{
    /**
     * This constant is used as a transformation flag; entities can be converted automatically into value objects
     * or other types, different methods in a class implementing this interface support this feature: look for
     * an <code>int</code> parameter called <code>transform</code>.
     * <p>
     * This specific flag denotes no transformation will occur.
     */
    public static final int TRANSFORM_NONE = 0;


    /**
     * Transforms the given results to a collection of {@link ObservedLocation}
     * instances (this is useful when the returned results contains a row of data and you want just entities only).
     *
     * @param results the query results.
     */
    public void toEntities(final Collection<?> results);

    /**
     * Gets an instance of ObservedLocation from the persistent store.
     * @param id
     * @return ObservedLocation
     */
    public ObservedLocation get(Integer id);

    /**
     * <p>
     * Does the same thing as {@link #get(Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param id the identifier of the entity to get.
     * @return either the entity or the object transformed from the entity.
     */
    public Object get(int transform, Integer id);

    /**
     * Loads an instance of ObservedLocation from the persistent store.
     * @param id
     * @return ObservedLocation
     */
    public ObservedLocation load(Integer id);

    /**
     * <p>
     * Does the same thing as {@link #load(Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param id the identifier of the entity to load.
     * @return either the entity or the object transformed from the entity.
     */
    public Object load(int transform, Integer id);

    /**
     * Loads all entities of type {@link ObservedLocation}.
     *
     * @return the loaded entities.
     */
    public Collection<ObservedLocation> loadAll();

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform);

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int pageNumber, final int pageSize);

    /**
     * <p>
     * Does the same thing as {@link #loadAll(int)} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform, final int pageNumber, final int pageSize);

    /**
     * Creates an instance of ObservedLocation and adds it to the persistent store.
     * @param observedLocation
     * @return ObservedLocation
     */
    public ObservedLocation create(ObservedLocation observedLocation);

    /**
     * <p>
     * Does the same thing as {@link #create(ObservedLocation)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param observedLocation
     * @return Object
     */
    public Object create(int transform, ObservedLocation observedLocation);

    /**
     * Creates a new instance of ObservedLocation and adds
     * from the passed in <code>entities</code> collection
     *
     * @param entities the collection of ObservedLocation
     * instances to create.
     *
     * @return the created instances.
     */
    public Collection<ObservedLocation> create(Collection<ObservedLocation> entities);

    /**
     * <p>
     * Does the same thing as {@link #create(ObservedLocation)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param entities
     * @return Collection
     */
    public Collection<?> create(int transform, Collection<ObservedLocation> entities);

    /**
     * <p>
     * Creates a new <code>ObservedLocation</code>
     * instance from <strong>all</strong> attributes and adds it to
     * the persistent store.
     * </p>
     * @param synchronizationStatus 
     * @param startDateTime 
     * @param endDateTime 
     * @param comments 
     * @param qualificationDate 
     * @param qualificationComments 
     * @param creationDate 
     * @param updateDate 
     * @param samplingStrataReference Référence du plan d'échantillonnage.
A n'utiliser que en attendant que les plans d'échantillonnage OBS-DEB soient importés dans Allegro.
@deprecated utiliser plutot SAMPLING_STRATA_FK
     * @param remoteId 
     * @return ObservedLocation
     */
    public ObservedLocation create(
        String synchronizationStatus,
        Date startDateTime,
        Date endDateTime,
        String comments,
        Date qualificationDate,
        String qualificationComments,
        Date creationDate,
        Timestamp updateDate,
        String samplingStrataReference,
        Integer remoteId);

    /**
     * <p>
     * Does the same thing as {@link #create(String, Date, Date, String, Date, String, Date, Timestamp, String, Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param synchronizationStatus 
     * @param startDateTime 
     * @param endDateTime 
     * @param comments 
     * @param qualificationDate 
     * @param qualificationComments 
     * @param creationDate 
     * @param updateDate 
     * @param samplingStrataReference Référence du plan d'échantillonnage.
A n'utiliser que en attendant que les plans d'échantillonnage OBS-DEB soient importés dans Allegro.
@deprecated utiliser plutot SAMPLING_STRATA_FK
     * @param remoteId 
     * @return ObservedLocation
     */
    public Object create(
        int transform,
        String synchronizationStatus,
        Date startDateTime,
        Date endDateTime,
        String comments,
        Date qualificationDate,
        String qualificationComments,
        Date creationDate,
        Timestamp updateDate,
        String samplingStrataReference,
        Integer remoteId);

    /**
     * <p>
     * Creates a new <code>ObservedLocation</code>
     * instance from only <strong>required</strong> properties (attributes
     * and association ends) and adds it to the persistent store.
     * </p>
     * @param creationDate
     * @param location
     * @param observers
     * @param program
     * @param qualityFlag
     * @param recorderDepartment
     * @param startDateTime
     * @param synchronizationStatus
     * @return ObservedLocation
     */
    public ObservedLocation create(
        Date creationDate,
        Location location,
        Collection<Person> observers,
        Program program,
        QualityFlag qualityFlag,
        Department recorderDepartment,
        Date startDateTime,
        String synchronizationStatus);

    /**
     * <p>
     * Does the same thing as {@link #create(String, Date, Date)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform flag to determine transformation type.
     * @param creationDate
     * @param location
     * @param observers
     * @param program
     * @param qualityFlag
     * @param recorderDepartment
     * @param startDateTime
     * @param synchronizationStatus
     * @return Object
     */
    public Object create(
        int transform,
        Date creationDate,
        Location location,
        Collection<Person> observers,
        Program program,
        QualityFlag qualityFlag,
        Department recorderDepartment,
        Date startDateTime,
        String synchronizationStatus);

    /**
     * Updates the <code>observedLocation</code> instance in the persistent store.
     * @param observedLocation
     */
    public void update(ObservedLocation observedLocation);

    /**
     * Updates all instances in the <code>entities</code> collection in the persistent store.
     * @param entities
     */
    public void update(Collection<ObservedLocation> entities);

    /**
     * Removes the instance of ObservedLocation from the persistent store.
     * @param observedLocation
     */
    public void remove(ObservedLocation observedLocation);

    /**
     * Removes the instance of ObservedLocation having the given
     * <code>identifier</code> from the persistent store.
     * @param id
     */
    public void remove(Integer id);

    /**
     * Removes all entities in the given <code>entities</code> collection.
     * @param entities
     */
    public void remove(Collection<ObservedLocation> entities);


    /**
     * Does the same thing as {@link #search(int, Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param transform the transformation flag.
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int transform, final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * finder results will <strong>NOT</strong> be transformed during retrieval.
     * If this flag is any of the other constants defined here
     * then results <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     *
     * @param transform the transformation flag.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<?> search(final int transform, final Search search);

    /**
     * Performs a search using the parameters specified in the given <code>search</code> object.
     *
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<ObservedLocation> search(final Search search);

    /**
     * Allows transformation of entities into value objects
     * (or something else for that matter), when the <code>transform</code>
     * flag is set to one of the constants defined in <code>fr.ifremer.adagio.core.dao.data.survey.observedLocation.ObservedLocationDao</code>, please note
     * that the {@link #TRANSFORM_NONE} constant denotes no transformation, so the entity itself
     * will be returned.
     *
     * If the integer argument value is unknown {@link #TRANSFORM_NONE} is assumed.
     *
     * @param transform one of the constants declared in {@link fr.ifremer.adagio.core.dao.data.survey.observedLocation.ObservedLocationDao}
     * @param entity an entity that was found
     * @return the transformed entity (i.e. new value object, etc)
     * @see #transformEntities(int,Collection)
     */
    public Object transformEntity(final int transform, final ObservedLocation entity);

    /**
     * Transforms a collection of entities using the
     * {@link #transformEntity(int,ObservedLocation)}
     * method. This method does not instantiate a new collection.
     * <p>
     * This method is to be used internally only.
     *
     * @param transform one of the constants declared in <code>fr.ifremer.adagio.core.dao.data.survey.observedLocation.ObservedLocationDao</code>
     * @param entities the collection of entities to transform
     * @see #transformEntity(int,ObservedLocation)
     */
    public void transformEntities(final int transform, final Collection<?> entities);

    // spring-dao merge-point
}