/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalCountDistinct
extends AggrFunction {
    @Override
    public String getName() {
        return "COUNTDISTINCT";
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getDataType() {
        return 2;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.ANY, "")};
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalCountDistinct.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalCountDistinct.displayName");
    }

    @Override
    public Object getDefaultValue() {
        return 0;
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private Set set;
        private boolean hasNullValue = false;

        private MyAccumulator() {
        }

        @Override
        public void start() {
            super.start();
            this.set = new HashSet();
            this.hasNullValue = false;
        }

        @Override
        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (args[0] instanceof Comparable) {
                this.set.add(args[0]);
            } else if (args[0] == null) {
                this.hasNullValue = true;
            } else {
                throw new DataException("aggregation.BadOperandType", args[0] == null ? null : args[0].getClass().getName());
            }
        }

        @Override
        public Object getSummaryValue() {
            return this.set.size() + (this.hasNullValue ? 1 : 0);
        }
    }
}

