/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.update.module;

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.update.ApplicationUpdateException;
import fr.ifremer.tutti.ui.swing.updater.UpdateModule;
import fr.ifremer.tutti.ui.swing.util.auth.AuthenticationInfo;
import java.util.Map;
import org.nuiton.i18n.I18n;
import org.nuiton.updater.ApplicationInfo;

public abstract class ModuleUpdaterSupport {
    protected final UpdateModule updateModule;

    public ModuleUpdaterSupport(UpdateModule updateModule) {
        this.updateModule = updateModule;
    }

    public UpdateModule getUpdateModule() {
        return this.updateModule;
    }

    public boolean matchUpdate(ApplicationInfo info) {
        return this.updateModule.name().toLowerCase().equals(info.name);
    }

    public ApplicationInfo updateToDo(TuttiUIContext context, Map<String, ApplicationInfo> appToUpdate) {
        AuthenticationInfo authenticationInfo;
        ApplicationInfo info = this.getInfo(appToUpdate);
        if (info != null && info.needAuthentication && (authenticationInfo = context.getAuthenticationInfo(info.url)) != null) {
            info.setAuthentication(authenticationInfo.getLogin(), authenticationInfo.getPassword());
        }
        this.onUpdateToDo(context, info);
        return info;
    }

    public boolean updateDone(TuttiUIContext context, Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) throws ApplicationUpdateException {
        ApplicationInfo info = this.getInfo(appToUpdate);
        Exception error = this.getError(appUpdateError);
        if (error != null) {
            String errorMessage = info != null && info.needAuthentication ? I18n.t((String)"tutti.update.error.with.auth", (Object[])new Object[]{this.getLabel()}) : I18n.t((String)"tutti.update.error.with.noauth", (Object[])new Object[]{this.getLabel()});
            throw new ApplicationUpdateException(this.updateModule, errorMessage, error);
        }
        boolean doRestart = false;
        if (info != null) {
            doRestart = true;
            this.onUpdateDone(context, info);
        }
        return doRestart;
    }

    protected abstract void onUpdateToDo(TuttiUIContext var1, ApplicationInfo var2);

    protected abstract void onUpdateDone(TuttiUIContext var1, ApplicationInfo var2);

    public abstract String getLabel();

    protected ApplicationInfo getInfo(Map<String, ApplicationInfo> appToUpdate) {
        return appToUpdate.get(this.updateModule.name().toLowerCase());
    }

    protected Exception getError(Map<String, Exception> appUpdateError) {
        return appUpdateError.get(this.updateModule.name().toLowerCase());
    }
}

