/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryV3;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.archive.compound.v3.Ext2Entry;
import org.eclipse.birt.core.archive.compound.v3.Ext2File;
import org.eclipse.birt.core.archive.compound.v3.Ext2FileSystem;

public class ArchiveFileV3
implements IArchiveFile {
    public static final String PROPERTY_SYSTEM_ID = "archive.system-id";
    public static final String PROPERTY_DEPEND_ID = "archive.depened-id";
    protected Ext2FileSystem fs;
    protected HashSet<ArchiveEntryV3> openedEntries = new HashSet();

    public ArchiveFileV3(String fileName, String mode) throws IOException {
        this(fileName, null, mode);
    }

    public ArchiveFileV3(String fileName, RandomAccessFile rf, String mode) throws IOException {
        this.fs = new Ext2FileSystem(fileName, rf, mode);
        if (this.fs.isRemoveOnExit()) {
            this.fs.setCacheSize(1024);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.openedEntries.isEmpty()) {
            ArrayList<ArchiveEntryV3> entries = new ArrayList<ArchiveEntryV3>(this.openedEntries);
            for (ArchiveEntryV3 entry : entries) {
                entry.close();
            }
            this.openedEntries.clear();
        }
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
    }

    public void setSystemId(String id) {
        this.fs.setProperty(PROPERTY_SYSTEM_ID, id);
    }

    public void setDependId(String id) {
        this.fs.setProperty(PROPERTY_DEPEND_ID, id);
    }

    @Override
    public synchronized ArchiveEntry createEntry(String name) throws IOException {
        Ext2File file = this.fs.createFile(name);
        return new ArchiveEntryV3(this, file);
    }

    @Override
    public boolean exists(String name) {
        return this.fs.existFile(name);
    }

    @Override
    public synchronized void flush() throws IOException {
        for (ArchiveEntryV3 entry : this.openedEntries) {
            entry.flush();
        }
        this.fs.flush();
    }

    @Override
    public String getDependId() {
        return this.fs.getProperty(PROPERTY_DEPEND_ID);
    }

    @Override
    public synchronized ArchiveEntry openEntry(String name) throws IOException {
        if (this.fs.existFile(name)) {
            Ext2File file = this.fs.openFile(name);
            return new ArchiveEntryV3(this, file);
        }
        throw new FileNotFoundException(name);
    }

    @Override
    public String getName() {
        return this.fs.getFileName();
    }

    @Override
    public String getSystemId() {
        return this.fs.getProperty(PROPERTY_SYSTEM_ID);
    }

    @Override
    public long getUsedCache() {
        return (long)this.fs.getUsedCacheSize() * 4096L;
    }

    @Override
    public List<String> listEntries(String namePattern) {
        Iterable<String> entryNames = namePattern == null ? this.fs.listAllFiles() : this.fs.listFiles(namePattern);
        ArrayList<String> files = new ArrayList<String>();
        for (String file : entryNames) {
            files.add(file);
        }
        return files;
    }

    @Override
    public synchronized Object lockEntry(String name) throws IOException {
        Ext2Entry entry;
        if (!this.fs.existFile(name) && !this.fs.isReadOnly()) {
            Ext2File file = this.fs.createFile(name);
            file.close();
        }
        if ((entry = this.fs.getEntry(name)) != null) {
            return entry;
        }
        throw new FileNotFoundException(name);
    }

    @Override
    public synchronized void refresh() throws IOException {
    }

    @Override
    public boolean removeEntry(String name) throws IOException {
        this.fs.removeFile(name);
        return true;
    }

    @Override
    public void save() throws IOException {
        this.fs.setRemoveOnExit(false);
        this.fs.flush();
    }

    @Override
    public void setCacheSize(long cacheSize) {
        long cacheBlock = cacheSize / 4096L;
        if (cacheBlock > Integer.MAX_VALUE) {
            this.fs.setCacheSize(Integer.MAX_VALUE);
        } else {
            this.fs.setCacheSize((int)cacheBlock);
        }
    }

    @Override
    public synchronized void unlockEntry(Object locker) throws IOException {
        assert (locker instanceof Ext2Entry);
    }

    protected synchronized void openEntry(ArchiveEntryV3 entry) {
        this.openedEntries.add(entry);
    }

    protected synchronized void closeEntry(ArchiveEntryV3 entry) {
        this.openedEntries.remove(entry);
    }
}

