package fr.ifremer.tutti.ui.swing.content.referential.replace;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public abstract class AbstractReplaceTemporaryUI<E extends TuttiReferentialEntity, M extends AbstractReplaceTemporaryUIModel<E>> extends JDialog implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DELETE_CHECK_BOX_SELECTED = "deleteCheckBox.selected";
    public static final String BINDING_REPLACE_BUTTON_ENABLED = "replaceButton.enabled";
    public static final String BINDING_SOURCE_LIST_COMBO_BOX_SELECTED_ITEM = "sourceListComboBox.selectedItem";
    public static final String BINDING_TARGET_LIST_COMBO_BOX_SELECTED_ITEM = "targetListComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWz28bRRR+NrET50dDExIKLVIJBRWQ1qGUEpSqtEkVkciBKHZRhQ9lvDuJp6x3l9nnZiMriD+BPwHO9ILEjRPiwJkDF8S/gFAPXBFvdte73vUa/6BEysp6877vvfnmzZv3+A8ouBJefsg8T5NtC0WLa3t37t//qPGQ63iXu7oUDtoSgr9cHvJ1mDMiu4vwSr2i4OUQXt62W45tcasHvVmBWRdPTe42OUeEl5II3XXL1Wh503PasssaJZXF+vWTP/NfGV9+kwfwHMpugbZyeRgq3slUBfLCQFiiSI9Y2WTWMaUhhXVM+S4o27bJXPdD1uKfwxcwXYGiwySRIayNvmWfw8d7DsKK5I7JdF7jhJBMnt7brdlkPziSmjiSvMWlhm1EobWF5p5QLppuW0jUmuRHXEUXzNRCFu1Ow0XJdDzsY3UcP2gRodCyDW4i3HvaIfYVbxyn9IiZwmC0d4Q3E6cQLYThqur7cdfYkymyhskRLiTQAaamlpRfKXJfdO221HlFuFhhDbXFJXVoXojY843KdymCLMUQOrOGvWV7CO9khOOGUPk2OLO0LfrsCBO5VDl0cUniRWTymGOUizI/n4odu/RyvJj0OkeacuTbTa5/5me3kthT154EzV/Zq3KqTSXnOsJqAhKtJDEzV/YOmMXN9bRsvjXFrzNL5+YWVQ1VCiwn/AOr8nw1AiyE1ROvvRE6SLiYkJvuvhbf/fhy5upQkG0yUznU+9vFIS0FjeJCqlEoQn/179XlX3/4/fudbneYo9grma49zY1urSNth0sUKvRi0BraKMzyPnM261By6Xz0oPNdykisGi5TchTvvIJrCq59wNwmURSmf/vxp9VPf3kG8jswa9rM2GHKfxdK2JSkgm0anvP+bT+j+ZMZ+j5L/3mEKVWMdBYdKiL/6l19/YxuHSFODrmr2uoUyjb3SJNLGZpEiTVKP/+1XP3udleXHOX5wkD3WJvCJ1AUliks7vfNsCVm9sk5x+Vtw45bX1YzBGp7q9l3K2wJ1/zvjT4xckFTY2a0ZeV309+L+nULBjVaZwjzFN0LU93fHdXFnuv0t4szFZN7pPa1oImm4xz29NAjwU1Di0kQ5tC2zZpwaj7FjfEpNKTnBQoPmtR6ETY7axNQKOzaWZZq6ZY6gl7zwYXgxi7yFsLFjv/caFSk1XCh6nP61ToTXq5TanRuYpliP4jeibCdv9fBqxPsb01F+r8UynhBxi2q/ndggqKKSSYuqphi4qLqofiXokq9jU+lqGo+58CiCpb/c1HFmU9aVCMplDEajFJU3c0SQSiQcO/644OvS1hS2qipBpNHupxGrsgAniyld0cXKoQPFik1GQ0TiKaQaW6pV4X0OR/p44+dvfKsD0+QHmhhW10XhNnAsKvGZpiOzPPirQ1r3+It2xI6Fdq4xForwiaP4PrYTIlDuD7oEA64dAmUwg4+geRUN+wACpHE5ZHzD+bMlMLFrjUl8MaYtAP1fXtcooS8G6PUeBI/WOLEpD1MYZqDiiY7tckZzt2kJscuN4Rl0FR+q487p76zQxmV+Vv1eZzN8Box/ANWB9q1NRAAAA==";
    private static final Log log = LogFactory.getLog(AbstractReplaceTemporaryUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected JCheckBox deleteCheckBox;
    protected AbstractReplaceTemporaryUIModel<E> model;
    protected JButton replaceButton;
    protected AbstractReplaceTemporaryUI<E, M> replaceTemporaryUITop = this;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedSource",  editorName = "sourceListComboBox")
    protected BeanFilterableComboBox<E> sourceListComboBox;
    protected JLabel sourceListLabel;
    protected Table table;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedTarget",  editorName = "targetListComboBox")
    protected BeanFilterableComboBox<E> targetListComboBox;
    protected JLabel targetListLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<AbstractReplaceTemporaryUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AbstractReplaceTemporaryUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI() {
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0) {
        super(param0);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setValid(false); dispose();
    }

    public void doItemStateChanged__on__deleteCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setDelete(event.getStateChange() == ItemEvent.SELECTED);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JCheckBox getDeleteCheckBox() {
        return deleteCheckBox;
    }

    public AbstractReplaceTemporaryUIModel<E> getModel() {
        return model;
    }

    public JButton getReplaceButton() {
        return replaceButton;
    }

    public BeanFilterableComboBox<E> getSourceListComboBox() {
        return sourceListComboBox;
    }

    public JLabel getSourceListLabel() {
        return sourceListLabel;
    }

    public Table getTable() {
        return table;
    }

    public BeanFilterableComboBox<E> getTargetListComboBox() {
        return targetListComboBox;
    }

    public JLabel getTargetListLabel() {
        return targetListLabel;
    }

    public SwingValidator<AbstractReplaceTemporaryUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToReplaceTemporaryUITop() {
        if (!allComponentsCreated) {
            return;
        }
        add(table, BorderLayout.CENTER);
    }

    protected void addChildrenToTable() {
        if (!allComponentsCreated) {
            return;
        }
        table.add(sourceListLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        table.add(SwingUtil.boxComponentWithJxLayer(sourceListComboBox), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        table.add(targetListLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        table.add(SwingUtil.boxComponentWithJxLayer(targetListComboBox), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        table.add(deleteCheckBox, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        table.add($JSeparator0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        table.add($JPanel0, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 15, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.replaceTemporaryReferential.action.cancel"));
        cancelButton.setToolTipText(t("tutti.replaceTemporaryReferential.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.replaceTemporaryReferential.action.cancel.help");
    }

    protected void createDeleteCheckBox() {
        $objectMap.put("deleteCheckBox", deleteCheckBox = new JCheckBox());
        
        deleteCheckBox.setName("deleteCheckBox");
        deleteCheckBox.setText(t("tutti.replaceTemporaryReferential.field.delete"));
        deleteCheckBox.setToolTipText(t("tutti.replaceTemporaryReferential.field.delete.tip"));
        deleteCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__deleteCheckBox"));
        deleteCheckBox.putClientProperty("help", "tutti.replaceTemporaryReferential.field.delete.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createReplaceButton() {
        $objectMap.put("replaceButton", replaceButton = new JButton());
        
        replaceButton.setName("replaceButton");
        replaceButton.setText(t("tutti.replaceTemporaryReferential.action.replace"));
        replaceButton.setToolTipText(t("tutti.replaceTemporaryReferential.action.replace.tip"));
        replaceButton.putClientProperty("help", "tutti.replaceTemporaryPerson.action.replace.help");
    }

    protected void createSourceListComboBox() {
        $objectMap.put("sourceListComboBox", sourceListComboBox = new BeanFilterableComboBox<E>(this));
        
        sourceListComboBox.setName("sourceListComboBox");
        sourceListComboBox.setProperty("selectedSource");
        sourceListComboBox.setShowReset(true);
        sourceListComboBox.putClientProperty("help", "tutti.replaceTemporaryReferential.field.sourceList.help");
        sourceListComboBox.putClientProperty("validatorLabel", t("tutti.replaceTemporaryReferential.field.sourceList"));
    }

    protected void createSourceListLabel() {
        $objectMap.put("sourceListLabel", sourceListLabel = new JLabel());
        
        sourceListLabel.setName("sourceListLabel");
        sourceListLabel.setText(t("tutti.replaceTemporaryReferential.field.sourceList"));
        sourceListLabel.setToolTipText(t("tutti.replaceTemporaryReferential.field.sourceList.tip"));
        sourceListLabel.putClientProperty("help", "tutti.replaceTemporaryReferential.field.sourceList.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new Table());
        
        table.setName("table");
    }

    protected void createTargetListComboBox() {
        $objectMap.put("targetListComboBox", targetListComboBox = new BeanFilterableComboBox<E>(this));
        
        targetListComboBox.setName("targetListComboBox");
        targetListComboBox.setProperty("selectedTarget");
        targetListComboBox.setShowReset(true);
        targetListComboBox.putClientProperty("help", "tutti.replaceTemporaryReferential.field.targetList.help");
        targetListComboBox.putClientProperty("validatorLabel", t("tutti.replaceTemporaryReferential.field.targetList"));
    }

    protected void createTargetListLabel() {
        $objectMap.put("targetListLabel", targetListLabel = new JLabel());
        
        targetListLabel.setName("targetListLabel");
        targetListLabel.setText(t("tutti.replaceTemporaryReferential.field.targetList"));
        targetListLabel.setToolTipText(t("tutti.replaceTemporaryReferential.field.targetList.tip"));
        targetListLabel.putClientProperty("help", "tutti.replaceTemporaryReferential.field.targetList.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(AbstractReplaceTemporaryUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReplaceTemporaryUITop();
        addChildrenToValidator();
        addChildrenToTable();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(replaceButton);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        sourceListLabel.setLabelFor(sourceListComboBox);
        sourceListComboBox.setBean(getModel());
        targetListLabel.setLabelFor(targetListComboBox);
        targetListComboBox.setBean(getModel());
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.replaceTemporaryReferential.action.cancel.mnemonic"),'Z'));
        replaceButton.setIcon(SwingUtil.createActionIcon("replace"));
        replaceButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.replaceTemporaryReferential.action.replace.mnemonic"),'Z'));
        // late initializer
        replaceTemporaryUITop.pack();
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("replaceTemporaryUITop", replaceTemporaryUITop);
        createModel();
        createValidator();
        createTable();
        createSourceListLabel();
        createSourceListComboBox();
        createTargetListLabel();
        createTargetListComboBox();
        createDeleteCheckBox();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createReplaceButton();
        // inline creation of replaceTemporaryUITop
        setName("replaceTemporaryUITop");
        replaceTemporaryUITop.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOURCE_LIST_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedSource", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sourceListComboBox.setSelectedItem(model.getSelectedSource());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedSource", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TARGET_LIST_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedTarget", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    targetListComboBox.setSelectedItem(model.getSelectedTarget());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedTarget", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("delete", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    deleteCheckBox.setSelected(model.isDelete());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("delete", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLACE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    replaceButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}