package fr.ifremer.tutti.ui.swing.content.referential;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ManageTemporaryReferentialUIHandler extends AbstractTuttiUIHandler<ManageTemporaryReferentialUIModel, ManageTemporaryReferentialUI> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ManageTemporaryReferentialUIHandler.class);

    protected JComponent currentBody;

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInit(ManageTemporaryReferentialUI ui) {
        super.beforeInit(ui);

        ManageTemporaryReferentialUIModel model = new ManageTemporaryReferentialUIModel();
        PersistenceService persistenceService = getContext().getPersistenceService();

        List<Species> temporarySpecies = new ArrayList<Species>(persistenceService.getAllSpecies());
        temporarySpecies = persistenceService.retainTemporarySpeciesList(temporarySpecies);
        model.setNbTemporarySpecies(temporarySpecies.size());

        List<Vessel> temporaryVessels = new ArrayList<Vessel>(persistenceService.getAllFishingVessel());
        temporaryVessels.addAll(persistenceService.getAllScientificVessel());
        temporaryVessels = persistenceService.retainTemporaryVesselList(temporaryVessels);
        model.setNbTemporaryVessels(temporaryVessels.size());

        List<Gear> temporaryGears = new ArrayList<Gear>(persistenceService.getAllFishingGear());
        temporaryGears.addAll(persistenceService.getAllScientificGear());
        temporaryGears = persistenceService.retainTemporaryGearList(temporaryGears);
        model.setNbTemporaryGears(temporaryGears.size());

        List<Person> temporaryPersons = new ArrayList<Person>(persistenceService.getAllPerson());
        temporaryPersons = persistenceService.retainTemporaryPersonList(temporaryPersons);
        model.setNbTemporaryPersons(temporaryPersons.size());

        ui.setContextValue(model);
    }

    @Override
    public void afterInit(ManageTemporaryReferentialUI ui) {

        initUI(ui);

        initActionComboBox(ui.getSpeciesActionComboBox());
        initActionComboBox(ui.getVesselActionComboBox());
        initActionComboBox(ui.getGearActionComboBox());
        initActionComboBox(ui.getPersonActionComboBox());
    }

    @Override
    protected JComponent getComponentToFocus() {
        return null;
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }
    }

    @Override
    public SwingValidator<ManageTemporaryReferentialUIModel> getValidator() {
        return null;
    }


    protected boolean resetExportSpeciesAction;

    protected boolean resetExportVesselsAction;

    protected boolean resetExportGearsAction;

    protected boolean resetExportPersonsAction;

    public void resetExportSpeciesAction() {
        resetExportSpeciesAction = true;
        try {
            ui.getSpeciesActionComboBox().setSelectedIndex(0);
        } finally {
            resetExportSpeciesAction = false;
        }
    }

    public void resetExportVesselsAction() {
        resetExportVesselsAction = true;
        try {
            ui.getVesselActionComboBox().setSelectedIndex(0);
        } finally {
            resetExportVesselsAction = false;
        }
    }

    public void resetExportGearsAction() {
        resetExportGearsAction = true;
        try {
            ui.getGearActionComboBox().setSelectedIndex(0);
        } finally {
            resetExportGearsAction = false;
        }
    }

    public void resetExportPersonAction() {
        resetExportPersonsAction = true;
        try {
            ui.getPersonActionComboBox().setSelectedIndex(0);
        } finally {
            resetExportPersonsAction = false;
        }
    }

    public void startExportSpeciesAction(MouseEvent event) {
        startComboFirstAction(event);
    }

    public void startExportSpeciesAction(ActionEvent event) {
        startEditAction(!resetExportSpeciesAction, event);
    }

    public void startExportVesselsAction(MouseEvent event) {
        startComboFirstAction(event);
    }

    public void startExportVesselsAction(ActionEvent event) {
        startEditAction(!resetExportVesselsAction, event);
    }

    public void startExportGearsAction(MouseEvent event) {
        startComboFirstAction(event);
    }

    public void startExportGearsAction(ActionEvent event) {
        startEditAction(!resetExportGearsAction, event);
    }

    public void startExportPersonsAction(MouseEvent event) {
        startComboFirstAction(event);
    }

    public void startExportPersonsAction(ActionEvent event) {
        startEditAction(!resetExportPersonsAction, event);
    }

    protected void startComboFirstAction(MouseEvent event) {
        JComboBox combo = (JComboBox) event.getSource();
        getContext().getActionEngine().runAction((AbstractButton) combo.getItemAt(0));
    }

    protected void startEditAction(boolean canEdit, ActionEvent event) {
        if (canEdit) {
            JComboBox existingCombo = (JComboBox) event.getSource();
            JButton selectedAction = (JButton) existingCombo.getSelectedItem();
            // hide popup before performing the action, otherwise, if the action
            // opens a popup, the user must click a first time to hide the combobox
            // popup to then interact with the popup opened by the action
            // (see http://forge.codelutin.com/issues/2032)
            existingCombo.setSelectedIndex(0);
            existingCombo.hidePopup();
            getContext().getActionEngine().runAction(selectedAction);
        }
    }

    protected void initActionComboBox(JComboBox combo) {
        combo.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        combo.addMouseListener(TuttiUIUtil.GRAB_FOCUS_ON_ENTER_LISTENER);
    }
}
