/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.replace.AbstractReplaceTemporaryUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public abstract class AbstractReplaceTemporaryUIAction<E extends TuttiReferentialEntity, M extends AbstractReplaceTemporaryUIModel<E>, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
extends AbstractTuttiAction<M, UI, H> {
    private static final Log log = LogFactory.getLog(AbstractReplaceTemporaryUIAction.class);
    protected E source;
    protected E target;
    protected Boolean delete;

    protected abstract String getEntityLabel();

    protected abstract void replaceReferentialEntity(PersistenceService var1, E var2, E var3, boolean var4);

    protected abstract void updateNumberOfTemporaryEntities(ManageTemporaryReferentialUI var1);

    protected AbstractReplaceTemporaryUIAction(H handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        AbstractReplaceTemporaryUIModel model;
        boolean doAction = super.prepareAction();
        if (doAction && (doAction = (model = (AbstractReplaceTemporaryUIModel)this.getModel()).isValid())) {
            this.source = model.getSelectedSource();
            this.target = model.getSelectedTarget();
            this.delete = model.isDelete();
        }
        ((TuttiUI)this.getUI()).getHandler().onCloseUI();
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull(this.source);
        Preconditions.checkNotNull(this.target);
        Preconditions.checkNotNull((Object)this.delete);
        String entityLabel = this.getEntityLabel();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Will replace %s temporary: %s by: %s", entityLabel, this.source.getName(), this.target.getName()));
        }
        this.replaceReferentialEntity(this.getContext().getPersistenceService(), this.source, this.target, this.delete);
    }

    public void releaseAction() {
        this.target = null;
        this.source = null;
        this.delete = null;
        super.releaseAction();
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        if (this.delete.booleanValue()) {
            ManageTemporaryReferentialUI mainUi = (ManageTemporaryReferentialUI)((TuttiUI)this.getUI()).getContextValue(ManageTemporaryReferentialUI.class, "owner");
            this.updateNumberOfTemporaryEntities(mainUi);
            this.sendMessage(I18n.t((String)"tutti.replaceTemporaryAndDelete.done", (Object[])new Object[]{this.getEntityLabel(), this.decorate(this.source), this.decorate(this.target)}));
        } else {
            this.sendMessage(I18n.t((String)"tutti.replaceTemporary.done", (Object[])new Object[]{this.getEntityLabel(), this.decorate(this.source), this.decorate(this.target)}));
        }
    }
}

