/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import java.util.Iterator;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.SnapshotGeneratorChain;
import liquibase.structure.DatabaseObject;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Table;

public abstract class HibernateSnapshotGenerator
implements SnapshotGenerator {
    private static final int PRIORITY_HIBERNATE_ADDITIONAL = 200;
    private static final int PRIORITY_HIBERNATE_DEFAULT = 100;
    private Class<? extends DatabaseObject> defaultFor = null;
    private Class<? extends DatabaseObject>[] addsTo = null;
    protected static final Logger LOG = LogFactory.getLogger((String)"liquibase-hibernate");

    protected HibernateSnapshotGenerator(Class<? extends DatabaseObject> defaultFor) {
        this.defaultFor = defaultFor;
    }

    protected HibernateSnapshotGenerator(Class<? extends DatabaseObject> defaultFor, Class<? extends DatabaseObject>[] addsTo) {
        this.defaultFor = defaultFor;
        this.addsTo = addsTo;
    }

    public final int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof HibernateDatabase) {
            if (this.defaultFor != null && this.defaultFor.isAssignableFrom(objectType)) {
                return 100;
            }
            if (this.addsTo() != null) {
                Class<? extends DatabaseObject>[] classArray = this.addsTo();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<? extends DatabaseObject> type = classArray[n2];
                    if (type.isAssignableFrom(objectType)) {
                        return 200;
                    }
                    ++n2;
                }
            }
        }
        return -1;
    }

    public final Class<? extends DatabaseObject>[] addsTo() {
        return this.addsTo;
    }

    public final <T extends DatabaseObject> T snapshot(T example, DatabaseSnapshot snapshot, SnapshotGeneratorChain chain) throws DatabaseException, InvalidExampleException {
        if (this.defaultFor != null && this.defaultFor.isAssignableFrom(example.getClass())) {
            T result = this.snapshotObject(example, snapshot);
            return result;
        }
        DatabaseObject chainResponse = chain.snapshot(example, snapshot);
        if (chainResponse == null) {
            return null;
        }
        if (this.addsTo() != null) {
            Class<? extends DatabaseObject>[] classArray = this.addsTo();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends DatabaseObject> addType = classArray[n2];
                if (addType.isAssignableFrom(example.getClass()) && chainResponse != null) {
                    this.addTo(chainResponse, snapshot);
                }
                ++n2;
            }
        }
        return (T)chainResponse;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return null;
    }

    protected abstract <T extends DatabaseObject> T snapshotObject(T var1, DatabaseSnapshot var2) throws DatabaseException, InvalidExampleException;

    protected abstract void addTo(DatabaseObject var1, DatabaseSnapshot var2) throws DatabaseException, InvalidExampleException;

    protected Table findHibernateTable(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        HibernateDatabase database = (HibernateDatabase)snapshot.getDatabase();
        Configuration cfg = database.getConfiguration();
        Iterator tableMappings = cfg.getTableMappings();
        while (tableMappings.hasNext()) {
            Table hibernateTable = (Table)tableMappings.next();
            if (!hibernateTable.getName().equals(example.getName())) continue;
            return hibernateTable;
        }
        return null;
    }
}

