/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.io.Files;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.ImportPupitriPopupUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Component;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.spi.UIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportPupitriPopupUIHandler
implements UIHandler<ImportPupitriPopupUI> {
    private static final Log log = LogFactory.getLog(ImportPupitriPopupUIHandler.class);
    protected ImportPupitriPopupUI ui;
    private boolean objectIsAdjusting;

    public void beforeInit(ImportPupitriPopupUI ui) {
        this.ui = ui;
    }

    public void afterInit(ImportPupitriPopupUI ui) {
        ui.getTrunkFile().setDialogOwner((JDialog)ui);
        ui.getCarrouselFile().setDialogOwner((JDialog)ui);
        ui.pack();
        ui.setResizable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTrunkFile() {
        if (this.objectIsAdjusting) {
            return;
        }
        File carrouselFile = this.ui.getCarrouselFile().getSelectedFile();
        if (carrouselFile != null) {
            String nameWithoutExtension = Files.getNameWithoutExtension((String)carrouselFile.getName());
            File trunkFile = new File(carrouselFile.getParentFile(), nameWithoutExtension + ".tnk");
            if (trunkFile.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Select from carrousel file, trunk file: " + trunkFile));
                }
                this.objectIsAdjusting = true;
                try {
                    this.ui.getTrunkFile().setSelectedFile(trunkFile);
                }
                finally {
                    this.objectIsAdjusting = false;
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No trunk file at " + trunkFile));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCarrouselFile() {
        if (this.objectIsAdjusting) {
            return;
        }
        File trunkFile = this.ui.getTrunkFile().getSelectedFile();
        if (trunkFile != null) {
            String nameWithoutExtension = Files.getNameWithoutExtension((String)trunkFile.getName());
            File carrouselFile = new File(trunkFile.getParentFile(), nameWithoutExtension + ".car");
            if (carrouselFile.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Select from trunk file, carrousel file: " + carrouselFile));
                }
                this.objectIsAdjusting = true;
                try {
                    this.ui.getCarrouselFile().setSelectedFile(carrouselFile);
                }
                finally {
                    this.objectIsAdjusting = false;
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No carrousel file at " + carrouselFile));
            }
        }
    }

    public void open() {
        this.resetFields();
        SwingUtil.center((Component)TuttiUIUtil.getApplicationContext(this.ui).getMainUI(), (Component)this.ui);
        this.ui.setVisible(true);
    }

    public void cancel() {
        this.resetFields();
        this.ui.dispose();
    }

    public void validate() {
        if (this.ui.getTrunkFile().getSelectedFile() != null && this.ui.getTrunkFile().getSelectedFile().exists() && this.ui.getCarrouselFile().getSelectedFile() != null && this.ui.getCarrouselFile().getSelectedFile().exists()) {
            this.ui.dispose();
        } else {
            JOptionPane.showMessageDialog(this.ui, I18n.t((String)"tutti.importPupitri.error.fileMissing.message", (Object[])new Object[0]), I18n.t((String)"tutti.importPupitri.error.fileMissing.title", (Object[])new Object[0]), 0);
        }
    }

    protected void resetFields() {
        this.ui.getTrunkFile().setSelectedFilePath(null);
        this.ui.getCarrouselFile().setSelectedFilePath(null);
    }
}

