/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class PatternPredicate
implements HighlightPredicate {
    public static final int ALL = -1;
    private int highlightColumn;
    private int testColumn;
    private Pattern pattern;

    public PatternPredicate(Pattern pattern, int testColumn) {
        this(pattern, testColumn, -1);
    }

    public PatternPredicate(Pattern pattern) {
        this(pattern, -1, -1);
    }

    public PatternPredicate(Pattern pattern, int testColumn, int decorateColumn) {
        this.pattern = pattern;
        this.testColumn = testColumn;
        this.highlightColumn = decorateColumn;
    }

    public PatternPredicate(String pattern) {
        this(pattern, -1, -1);
    }

    public PatternPredicate(String regex, int testColumn) {
        this(regex, testColumn, -1);
    }

    public PatternPredicate(String regex, int testColumn, int decorateColumn) {
        this(Pattern.compile(regex), testColumn, decorateColumn);
    }

    @Override
    public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
        if (this.isHighlightCandidate(adapter)) {
            return this.test(adapter);
        }
        return false;
    }

    private boolean test(ComponentAdapter adapter) {
        if (this.testColumn >= 0) {
            return this.testColumn(adapter, this.testColumn);
        }
        for (int column = 0; column < adapter.getColumnCount(); ++column) {
            boolean result = this.testColumn(adapter, column);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private boolean testColumn(ComponentAdapter adapter, int testColumn) {
        if (!adapter.isTestable(testColumn)) {
            return false;
        }
        String value = adapter.getString(testColumn);
        if (value == null || value.length() == 0) {
            return false;
        }
        return this.pattern.matcher(value).find();
    }

    private boolean isHighlightCandidate(ComponentAdapter adapter) {
        return this.pattern != null && (this.highlightColumn < 0 || this.highlightColumn == adapter.convertColumnIndexToModel(adapter.column));
    }

    public int getHighlightColumn() {
        return this.highlightColumn;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public int getTestColumn() {
        return this.testColumn;
    }
}

