/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.computable;

import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import fr.ifremer.tutti.util.Weights;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.widgets.number.NumberEditorHandler;

public class ComputableDataEditorHandler
extends NumberEditorHandler {
    protected Integer decimalNumber;

    public void init() {
        final PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ComputableDataEditorHandler.this.setComputedTextIfNullModel();
            }
        };
        ComputableData bean = (ComputableData)((Object)this.ui.getModel().getBean());
        if (bean != null) {
            bean.addPropertyChangeListener(l);
        }
        this.ui.getModel().addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ComputableData bean = (ComputableData)((Object)evt.getOldValue());
                if (bean != null) {
                    bean.removePropertyChangeListener("computedData", l);
                }
                if ((bean = (ComputableData)((Object)evt.getNewValue())) != null) {
                    bean.addPropertyChangeListener("computedData", l);
                }
            }
        });
        this.ui.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextField tf = ComputableDataEditorHandler.this.ui.getTextField();
                tf.setFont(TuttiUI.TEXTFIELD_NORMAL_FONT);
                tf.setForeground(Color.BLACK);
                if (ComputableDataEditorHandler.this.ui.getModel() == null) {
                    tf.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                ComputableDataEditorHandler.this.setComputedTextIfNullModel();
            }
        });
        this.ui.addPropertyChangeListener("decimalNumber", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ComputableDataEditorHandler.this.decimalNumber = (Integer)evt.getNewValue();
            }
        });
        this.decimalNumber = ((ComputableDataEditor)this.ui).getDecimalNumber();
        super.init();
    }

    protected void setComputedTextIfNullModel() {
        ComputableData bean = (ComputableData)((Object)this.ui.getModel().getBean());
        JTextField tf = this.ui.getTextField();
        if (bean != null) {
            String modelText;
            tf.setFont(TuttiUI.TEXTFIELD_COMPUTED_FONT);
            tf.setForeground(((ComputableDataEditor)this.ui).getComputedDataColor());
            Object computedData = bean.getComputedData();
            if (this.decimalNumber != null && computedData != null) {
                DecimalFormat decimalFormat = Weights.getDecimalFormat((int)1, (int)this.decimalNumber);
                modelText = decimalFormat.format(computedData);
            } else {
                modelText = JAXXUtil.getStringValue(computedData);
            }
            tf.setText(modelText);
        } else {
            tf.setFont(TuttiUI.TEXTFIELD_NORMAL_FONT);
            tf.setForeground(Color.BLACK);
        }
    }
}

