/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ThemeEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.AbstractTheme;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class ThemeRecord
extends SimpleRecord {
    private ElementRefValue newTheme;
    private ElementRefValue oldTheme;
    protected DesignElement element;

    ThemeRecord(DesignElement element, ElementRefValue newTheme) {
        this.element = element;
        this.newTheme = newTheme;
        this.oldTheme = (ElementRefValue)element.getLocalProperty(element.getRoot(), "theme");
        this.label = CommandLabelFactory.getCommandLabel("Message.SetTheme");
    }

    @Override
    protected void perform(boolean undo) {
        if (undo) {
            this.element.setProperty("theme", (Object)this.oldTheme);
            this.updateStyles(this.newTheme);
        } else {
            this.element.setProperty("theme", (Object)this.newTheme);
            this.updateStyles(this.oldTheme);
        }
    }

    @Override
    public DesignElement getTarget() {
        return this.element;
    }

    @Override
    public NotificationEvent getEvent() {
        return new ThemeEvent(this.element);
    }

    private void updateStyles(ElementRefValue theme) {
        if (theme == null) {
            return;
        }
        if (!theme.isResolved()) {
            return;
        }
        AbstractTheme t = (AbstractTheme)theme.getElement();
        List<StyleElement> styles = t.getAllStyles();
        for (StyleElement style : styles) {
            style.updateClientReferences();
        }
    }
}

