/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition.core;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.precondition.Precondition;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.DatabaseSnapshotGeneratorFactory;
import liquibase.util.StringUtils;

public class PrimaryKeyExistsPrecondition
implements Precondition {
    private String schemaName;
    private String primaryKeyName;
    private String tableName;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public void setPrimaryKeyName(String primaryKeyName) {
        this.primaryKeyName = primaryKeyName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Warnings warn(Database database) {
        return new Warnings();
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet) throws PreconditionFailedException, PreconditionErrorException {
        DatabaseSnapshot snapshot;
        try {
            snapshot = DatabaseSnapshotGeneratorFactory.getInstance().createSnapshot(database, this.getSchemaName(), null);
        }
        catch (DatabaseException e) {
            throw new PreconditionErrorException(e, changeLog, this);
        }
        if (this.tableName != null) {
            if (snapshot.getPrimaryKeyForTable(this.getTableName()) == null) {
                throw new PreconditionFailedException("Primary Key does not exist on " + database.escapeStringForDatabase(this.getTableName()), changeLog, this);
            }
        } else if (this.primaryKeyName != null) {
            if (snapshot.getPrimaryKey(this.getPrimaryKeyName()) == null) {
                throw new PreconditionFailedException("Primary Key " + database.escapeStringForDatabase(this.getPrimaryKeyName()) + " does not exist", changeLog, this);
            }
        } else {
            throw new RuntimeException("primaryKeyExists precondition requires a tableName or primaryKeyName");
        }
    }

    public String getName() {
        return "primaryKeyExists";
    }
}

