/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.shared.application;

import com.google.common.base.Preconditions;
import fr.ifremer.shared.application.ApplicationTechnicalException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.nuiton.i18n.I18n;

public class ApplicationDataUtil {
    public static final double EARTH_RADIUS = 6378288.0;
    private static final MathContext MATH_CONTEXT_4_DIGIT = new MathContext(4);
    private static DecimalFormatSymbols symbols;
    private static DecimalFormat decimalFormat;

    public static int computeDistanceInMeters(Float startLatitude, Float startLongitude, Float endLatitude, Float endLongitude) {
        double sLat = (double)startLatitude.floatValue() * Math.PI / 180.0;
        double sLong = (double)startLongitude.floatValue() * Math.PI / 180.0;
        double eLat = (double)endLatitude.floatValue() * Math.PI / 180.0;
        double eLong = (double)endLongitude.floatValue() * Math.PI / 180.0;
        Double d = 6378288.0 * (1.5707963267948966 - Math.asin(Math.sin(eLat) * Math.sin(sLat) + Math.cos(eLong - sLong) * Math.cos(eLat) * Math.cos(sLat)));
        return d.intValue();
    }

    public static String getDistanceInMilles(Float distance) {
        String distanceText;
        if (distance != null) {
            Float distanceInMilles = Float.valueOf(distance.floatValue() / 1852.0f);
            distanceText = String.format("%.3f", distanceInMilles);
        } else {
            distanceText = "";
        }
        return distanceText;
    }

    public static float getRoundedLengthStep(float lengthStep, boolean aroundUp) {
        int intValue = (int)((lengthStep + (aroundUp ? 0.001f : 0.0f)) * 10.0f);
        float result = (float)intValue / 10.0f;
        return result;
    }

    public static void setProperty(Object bean, String property, Object value) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            PropertyUtils.setSimpleProperty((Object)bean, (String)property, (Object)value);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n._((String)"application.property.set.error", (Object[])new Object[]{property, bean.getClass().getName()}), e);
        }
    }

    public static Object getProperty(Object bean, String property) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            return PropertyUtils.getSimpleProperty((Object)bean, (String)property);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n._((String)"application.property.get.error", (Object[])new Object[]{property, bean.getClass().getName()}), e);
        }
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        if (symbols == null) {
            symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            symbols.setGroupingSeparator(' ');
        }
        return symbols;
    }

    public static DecimalFormat getDecimalFormat(int minDecimal, int maxDecimal) {
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat();
            decimalFormat.setDecimalFormatSymbols(ApplicationDataUtil.getDecimalFormatSymbols());
            decimalFormat.setGroupingUsed(false);
        }
        decimalFormat.setMinimumFractionDigits(minDecimal);
        decimalFormat.setMaximumFractionDigits(maxDecimal);
        return decimalFormat;
    }

    public static String getWeightStringValue(Float weight) {
        String textValue;
        if (weight != null) {
            DecimalFormat weightDecimalFormat = ApplicationDataUtil.getDecimalFormat(1, 3);
            textValue = weightDecimalFormat.format(weight);
        } else {
            textValue = "";
        }
        return textValue;
    }

    public static <N extends Number> N getValueOrComputedValue(N value, N computedValue) {
        return value == null ? computedValue : value;
    }

    public static <N extends Number> Boolean getValueOrComputedValueComputed(N value, N computedValue) {
        Boolean result = value == null ? (computedValue == null ? null : Boolean.valueOf(true)) : Boolean.valueOf(false);
        return result;
    }

    public static float roundKiloGram(float value) {
        BigDecimal sumB = new BigDecimal(value);
        float result = sumB.abs(MATH_CONTEXT_4_DIGIT).floatValue();
        return result;
    }

    public static String getDuration(Date startDate, Date endDate, String format) {
        String duration = "";
        if (startDate != null && endDate != null && !startDate.after(endDate)) {
            duration = DurationFormatUtils.formatPeriod((long)startDate.getTime(), (long)endDate.getTime(), (String)format);
        }
        return duration;
    }
}

