package fr.ifremer.tutti.ui.swing.content.report;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class ReportUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<ReportUIModel, ReportUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM = "fishingOperationComboBox.selectedItem";
    public static final String BINDING_GENERATE_BUTTON_ENABLED = "generateButton.enabled";
    public static final String BINDING_OUTPUT_FILE_FIELD_SELECTED_FILE = "outputFileField.selectedFile";
    public static final String BINDING_REPORT_COMBO_BOX_SELECTED_ITEM = "reportComboBox.selectedItem";
    public static final String BINDING_SHOW_OUTPUT_FILE_BUTTON_ENABLED = "showOutputFileButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XS28cRRBub7xrr5OQ+BHngY38DHnAOD6AkAwkccgmjhwc2QuK8MH0zvTaHWanh56eZK2VET+BnwB3LkjcOCEOnDlwQfwBkFDEgSuiumd2Znu2Z3ctEylju6e+r6vqq67q+fYvVAw4mn+Gm02Lh56gDWI9uvv06VbtGbHFBySwOfUF4yj6N1RAhV102knWA4EWdzclfCWGr9xjDZ95xOtAr22isUAcuiQ4IEQINKsj7CBY2UlerzX9kLdZE6dMrF///bLwlfPlNwWEmj54Nw6hzPVDpZEMb6ICdQSagJ2e4xUXe/vgBqfePvh7Vq7dc3EQfIgb5HP0BRrZRCUfcyATaGHwkBWHwjd9gV7hxGdcVJn/BHvEFWi1zi1a56RBuCVCIagVUit4AU5YNvMEcFoRxNpWPz7a8H1FVxKo2GCO5Hj72ByPJTAlKtU4+4xwga7nM1Xlnw8Bta5sU3D5OXapgyFmgW5q2U9exBQ78vlxezFlGK4z3hDokgaOd8U1V2W/nFhfqNPgAN5t+YRjQZm3iWsyCxNSsWaMe6QWJeJCAryUBYJsNbbOmgK9ZdiaOFS6XiPYs9bhUaGuACD408bp9KejHCcbX9Ffx8p3Ymd1i3MsFH4oYB+SR9JhEtePHrVazIVUKHGh3pfyg5VW99WvEr2UkFxMSe7aMnVVxtwaBsWntP3l8jrOgKeCA/ZiKyFYh0KCqkSTGjJalYgbCXB0KQrolvz7aibbtssCkqJW5ONWmu194kmVDRYcvaolALqPlXaftD0M7aIiD2EZKme3u2Ftw6uoVV3KtCpJqN7+Oz356w+/f19p96cp2PuC0bSjvULf8DmDEhVUbn0uak6hoO7KY+yv7aJyQFzozar3zhgc24lfg3Ow37iEWxJuPcTBAVAUR3778afpT385hQoVNOYy7FSwtN9AZXHAIQvMdZr+7TvKozMvRuF5Hv4X4JzKsyDQSEv1nSM4+lLZbRLInj4seEiakI4ZQzoSn2rln/+Z3PnuTjslQ+Di5VzzNC3FT1CJei71iGracT82NunTfkBCh6V919SJEfTiafOpjvvSmnre7srDEBTXXiTBlldhdggylFoy+KNmKCH3VVjytwdyl7FHVdIU6uj1ZzYk1ESZHtM+lCBauQ4SCxkgDIw6doEbna0x7hD+BFOYDk57vXuv/IPv94+luHcA0wL6dWshGiXxDJKrC4ZcdQ3HfnsMQ4dwZaOsyNFzvqU32COZQci8QJe17etSifgPaCMC4qlSv6osZ3MtLQFTPQlpIROSZpkfX+eEGCC4M1GVEWdDEBiPk9Gxs/aJiMb4tesQ42jcLA6hCttBndtLJm88G+dae9fyXV6QRCeMLTPejqfdlVbeaE5VXDR4lUVl9Xx9AIyu7BvG6Lsw+Xkw306Or/ZsqnYlw5jV/Xx3Gror4EZOBWSxWi2cOBu5V67j1cd4K3OJScvCdGRT42xBzPe01kvhqjH4Duv8sLM3uX7RnuqQP3L7Yip/enNSwndLu5QjbeqEJur/E1c80HrHVYTLAvHk7IEhMxOHRIM0ovtNGohAxTWG1XzZkF8sqAy17b1ZV6k4Q1ff8R57pME8asMnhuZ8BLL0G6bVSKx1+a8OgNVq4GYmV2ZIfsKMV99+WSslxX3FtLmNPVvKriWs1F6d2MO+71JbnbZoZAt0t5X/XRezPmBV9oST55SFwY7NCYnBli1vTUddMizmu5ab/td6YLS0L5rTHpv2GLAdHwX9sjzSWZvjSW2qz1NVkLEGMyZP2l8XGRVG03WjDu8NoEPMEI343hos93ItV4W5nihNh2WzDolxj+uA/v01wHWx5OJDaC8AfReaG56rUc+BvLzfxT4kn2MDMI7Kz5Xqoa8+DP4088z05ZHLL3swzA/E8EcPhuUTM9w8McMqMPwH9rKQTQ0UAAA=";
    private static final Log log = LogFactory.getLog(ReportUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton closeButton;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperation",  editorName = "fishingOperationComboBox")
    protected BeanFilterableComboBox<FishingOperation> fishingOperationComboBox;
    protected JLabel fishingOperationLabel;
    protected Table form;
    protected JButton generateButton;
    protected final ReportUIHandler handler = new ReportUIHandler();
    protected ReportUIModel model;
    protected JToolBar outputFileActionToolbar;
    @ValidatorField( validatorId = "validator",  propertyName = "outputFile",  editorName = "outputFileField")
    protected FileEditor outputFileField;
    protected JLabel outputFileLabel;
    protected JPanel outputFilePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "report",  editorName = "reportComboBox")
    protected BeanFilterableComboBox<File> reportComboBox;
    protected JLabel reportLabel;
    protected ReportUI reportTopPanel = this;
    protected JButton showOutputFileButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<ReportUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ReportUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public ReportUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReportUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReportUI() {
        $initialize();
    }

    public ReportUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReportUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ReportUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReportUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ReportUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__outputFileField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setFile(event, "outputFile");
    }

    public void doActionPerformed__on__showOutputFileButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showReport();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public BeanFilterableComboBox<FishingOperation> getFishingOperationComboBox() {
        return fishingOperationComboBox;
    }

    public JLabel getFishingOperationLabel() {
        return fishingOperationLabel;
    }

    public Table getForm() {
        return form;
    }

    public JButton getGenerateButton() {
        return generateButton;
    }

    public ReportUIHandler getHandler() {
        return handler;
    }

    public ReportUIModel getModel() {
        return model;
    }

    public JToolBar getOutputFileActionToolbar() {
        return outputFileActionToolbar;
    }

    public FileEditor getOutputFileField() {
        return outputFileField;
    }

    public JLabel getOutputFileLabel() {
        return outputFileLabel;
    }

    public JPanel getOutputFilePanel() {
        return outputFilePanel;
    }

    public BeanFilterableComboBox<File> getReportComboBox() {
        return reportComboBox;
    }

    public JLabel getReportLabel() {
        return reportLabel;
    }

    public JButton getShowOutputFileButton() {
        return showOutputFileButton;
    }

    public SwingValidator<ReportUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(fishingOperationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(fishingOperationComboBox), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(reportLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(reportComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(outputFileLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(outputFilePanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add($JPanel0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 15, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToOutputFileActionToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        outputFileActionToolbar.add(showOutputFileButton);
    }

    protected void addChildrenToOutputFilePanel() {
        if (!allComponentsCreated) {
            return;
        }
        outputFilePanel.add(SwingUtil.boxComponentWithJxLayer(outputFileField), BorderLayout.CENTER);
        outputFilePanel.add(outputFileActionToolbar, BorderLayout.EAST);
    }

    protected void addChildrenToReportTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(form);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.report.help"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("tutti.report.action.cancel"));
        closeButton.setToolTipText(_("tutti.report.action.cancel.tip"));
        closeButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.GoToPreviousScreenAction.class);
        closeButton.putClientProperty("help", "tutti.report.action.cancel.help");
    }

    protected void createFishingOperationComboBox() {
        $objectMap.put("fishingOperationComboBox", fishingOperationComboBox = new BeanFilterableComboBox<FishingOperation>(this));
        
        fishingOperationComboBox.setName("fishingOperationComboBox");
        fishingOperationComboBox.setProperty("fishingOperation");
        fishingOperationComboBox.setShowReset(true);
        fishingOperationComboBox.putClientProperty("help", "tutti.report.field.fishingOperation.help");
        fishingOperationComboBox.putClientProperty("validatorLabel", _("tutti.report.field.fishingOperation"));
    }

    protected void createFishingOperationLabel() {
        $objectMap.put("fishingOperationLabel", fishingOperationLabel = new JLabel());
        
        fishingOperationLabel.setName("fishingOperationLabel");
        fishingOperationLabel.setText(_("tutti.report.field.fishingOperation"));
        fishingOperationLabel.setToolTipText(_("tutti.report.field.fishingOperation.tip"));
        fishingOperationLabel.putClientProperty("help", "tutti.report.field.fishingOperation.help");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createGenerateButton() {
        $objectMap.put("generateButton", generateButton = new JButton());
        
        generateButton.setName("generateButton");
        generateButton.setText(_("tutti.report.action.generate"));
        generateButton.setToolTipText(_("tutti.report.action.generate.tip"));
        generateButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.GenerateReportAction.class);
        generateButton.putClientProperty("help", "tutti.report.action.generate.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ReportUIModel.class));
    }

    protected void createOutputFileActionToolbar() {
        $objectMap.put("outputFileActionToolbar", outputFileActionToolbar = new JToolBar());
        
        outputFileActionToolbar.setName("outputFileActionToolbar");
        outputFileActionToolbar.setLayout(new GridLayout());
        outputFileActionToolbar.setFloatable(false);
        outputFileActionToolbar.setBorderPainted(false);
    }

    protected void createOutputFileField() {
        $objectMap.put("outputFileField", outputFileField = new FileEditor());
        
        outputFileField.setName("outputFileField");
        outputFileField.setShowReset(true);
        outputFileField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__outputFileField"));
        outputFileField.putClientProperty("help", "tutti.report.field.outputFile.help");
        outputFileField.putClientProperty("validatorLabel", _("tutti.report.field.outputFile"));
    }

    protected void createOutputFileLabel() {
        $objectMap.put("outputFileLabel", outputFileLabel = new JLabel());
        
        outputFileLabel.setName("outputFileLabel");
        outputFileLabel.setText(_("tutti.report.field.outputFile"));
        outputFileLabel.setToolTipText(_("tutti.report.field.outputFile.tip"));
        outputFileLabel.putClientProperty("help", "tutti.report.field.outputFile.help");
    }

    protected void createOutputFilePanel() {
        $objectMap.put("outputFilePanel", outputFilePanel = new JPanel());
        
        outputFilePanel.setName("outputFilePanel");
        outputFilePanel.setLayout(new BorderLayout());
    }

    protected void createReportComboBox() {
        $objectMap.put("reportComboBox", reportComboBox = new BeanFilterableComboBox<File>(this));
        
        reportComboBox.setName("reportComboBox");
        reportComboBox.setProperty("report");
        reportComboBox.setShowReset(true);
        reportComboBox.putClientProperty("help", "tutti.report.field.report.help");
        reportComboBox.putClientProperty("validatorLabel", _("tutti.report.field.report"));
    }

    protected void createReportLabel() {
        $objectMap.put("reportLabel", reportLabel = new JLabel());
        
        reportLabel.setName("reportLabel");
        reportLabel.setText(_("tutti.report.field.report"));
        reportLabel.setToolTipText(_("tutti.report.field.report.tip"));
        reportLabel.putClientProperty("help", "tutti.report.field.report.help");
    }

    protected void createShowOutputFileButton() {
        $objectMap.put("showOutputFileButton", showOutputFileButton = new JButton());
        
        showOutputFileButton.setName("showOutputFileButton");
        showOutputFileButton.setToolTipText(_("tutti.report.action.showOutputFile.tip"));
        showOutputFileButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__showOutputFileButton"));
        showOutputFileButton.putClientProperty("help", "tutti.report.action.showOutputFile.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(ReportUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReportTopPanel();
        addChildrenToValidator();
        addChildrenToForm();
        addChildrenToOutputFilePanel();
        addChildrenToOutputFileActionToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(closeButton);
        $JPanel0.add(generateButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        fishingOperationComboBox.setBeanType(FishingOperation.class);
        reportComboBox.setBeanType(File.class);
        fishingOperationLabel.setLabelFor(fishingOperationComboBox);
        fishingOperationComboBox.setBean(model);
        reportLabel.setLabelFor(reportComboBox);
        reportComboBox.setBean(model);
        outputFileLabel.setLabelFor(outputFileField);
        showOutputFileButton.setIcon(SwingUtil.createActionIcon("open-file"));
        showOutputFileButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.report.action.showOutputFile.mnemonic"),'Z'));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.report.action.cancel.mnemonic"),'Z'));
        generateButton.setIcon(SwingUtil.createActionIcon("generate"));
        generateButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.report.action.generate.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, reportTopPanel, "tutti.report.help");
        registerHelpId(_broker, fishingOperationLabel, "tutti.report.field.fishingOperation.help");
        registerHelpId(_broker, fishingOperationComboBox, "tutti.report.field.fishingOperation.help");
        registerHelpId(_broker, reportLabel, "tutti.report.field.report.help");
        registerHelpId(_broker, reportComboBox, "tutti.report.field.report.help");
        registerHelpId(_broker, outputFileLabel, "tutti.report.field.outputFile.help");
        registerHelpId(_broker, outputFileField, "tutti.report.field.outputFile.help");
        registerHelpId(_broker, showOutputFileButton, "tutti.report.action.showOutputFile.help");
        registerHelpId(_broker, closeButton, "tutti.report.action.cancel.help");
        registerHelpId(_broker, generateButton, "tutti.report.action.generate.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("reportTopPanel", reportTopPanel);
        createModel();
        createBroker();
        createValidator();
        createForm();
        createFishingOperationLabel();
        createFishingOperationComboBox();
        createReportLabel();
        createReportComboBox();
        createOutputFileLabel();
        createOutputFilePanel();
        createOutputFileField();
        createOutputFileActionToolbar();
        createShowOutputFileButton();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCloseButton();
        createGenerateButton();
        // inline creation of reportTopPanel
        setName("reportTopPanel");
        setLayout(new BorderLayout());
        reportTopPanel.putClientProperty("help", "tutti.report.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationComboBox.setSelectedItem(model.getFishingOperation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPORT_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("report", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    reportComboBox.setSelectedItem(model.getReport());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("report", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OUTPUT_FILE_FIELD_SELECTED_FILE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("outputFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    outputFileField.setSelectedFile(model.getOutputFile());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("outputFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SHOW_OUTPUT_FILE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("outputFileExists", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    showOutputFileButton.setEnabled(model.isOutputFileExists());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("outputFileExists", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}