/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.liquibase;

import fr.ifremer.adagio.core.dao.technical.Version;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component(value="liquibase")
public class Liquibase
implements InitializingBean,
BeanNameAware,
ResourceLoaderAware {
    protected static final String CHANGE_LOG_PATH = "classpath:fr/ifremer/adagio/core/db/changelog/db-changelog-master.xml";
    private String beanName;
    private PathMatchingResourcePatternResolver resolver;
    private ResourceLoader resourceLoader;
    private DataSource dataSource;
    private String changeLog;
    private String defaultSchema;
    private String contexts;
    private Map<String, String> parameters;
    @Value(value="${liquibase.should.run}")
    protected Boolean shouldRun = false;
    protected Version maxChangeLogFileVersion;

    @Autowired
    public Liquibase(DataSource dataSource) {
        this.setDataSource(dataSource);
        this.setChangeLog(CHANGE_LOG_PATH);
    }

    public String getDatabaseProductName() throws DatabaseException {
        Connection connection = null;
        String name = "unknown";
        try {
            connection = this.getDataSource().getConnection();
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.dataSource.getConnection()));
            name = database.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    connection.close();
                }
                catch (Exception e) {
                    LogFactory.getLogger().warning("problem closing connection", (Throwable)e);
                }
            }
        }
        return name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String dataModel) {
        this.changeLog = dataModel;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public void afterPropertiesSet() throws LiquibaseException {
        this.computeMaxChangeLogFileVersion();
        if (this.shouldRun != null && !this.shouldRun.booleanValue()) {
            LogFactory.getLogger().info("Liquibase did not run because 'liquibase.should.run' was set to false in conf.properties file.");
            return;
        }
        String shouldRunProperty = System.getProperty("liquibase.should.run");
        if (shouldRunProperty != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
            LogFactory.getLogger().info("Liquibase did not run because 'liquibase.should.run' system property was set to false");
            return;
        }
        this.executeUpdate();
    }

    public void executeUpdate() throws LiquibaseException {
        Connection c = null;
        try {
            c = this.getDataSource().getConnection();
            liquibase.Liquibase liquibase = this.createLiquibase(c);
            liquibase.forceReleaseLocks();
            this.performUpdate(liquibase);
            liquibase.forceReleaseLocks();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        finally {
            if (c != null) {
                try {
                    c.rollback();
                    c.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    protected void performUpdate(liquibase.Liquibase liquibase) throws LiquibaseException {
        liquibase.update(this.getContexts());
    }

    protected liquibase.Liquibase createLiquibase(Connection c) throws LiquibaseException {
        liquibase.Liquibase liquibase = new liquibase.Liquibase(this.getChangeLog(), (ResourceAccessor)this.createResourceOpener(), this.createDatabase(c));
        if (this.parameters != null) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), (Object)entry.getValue());
            }
        }
        return liquibase;
    }

    protected Database createDatabase(Connection c) throws DatabaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(c));
        if (StringUtils.trimToNull((String)this.defaultSchema) != null) {
            database.setDefaultSchemaName(this.defaultSchema);
        }
        return database;
    }

    public void setChangeLogParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    protected SpringResourceOpener createResourceOpener() {
        return new SpringResourceOpener(this.getChangeLog());
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getResourceLoader().toString() + ")";
    }

    protected void computeMaxChangeLogFileVersion() {
        this.maxChangeLogFileVersion = null;
        String changeLogPath = this.getChangeLog();
        if (org.apache.commons.lang.StringUtils.isBlank((String)changeLogPath)) {
            return;
        }
        int index = (changeLogPath = changeLogPath.replaceAll("\\\\", "/")).lastIndexOf(47);
        if (index == -1 || index == changeLogPath.length() - 1) {
            return;
        }
        String changeLogWithVersionRegex = changeLogPath.substring(index + 1);
        changeLogWithVersionRegex = changeLogWithVersionRegex.replaceAll("master\\.xml", "([0-9]\\\\.[.-_a-zA-Z]+)\\\\.xml");
        Pattern changeLogWithVersionPattern = Pattern.compile(changeLogWithVersionRegex);
        Version maxVersion = null;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
        try {
            Resource[] resources;
            String pathPrefix = changeLogPath.substring(0, index);
            for (Resource resource : resources = resolver.getResources(pathPrefix + "/db-changelog-*.xml")) {
                String filename = resource.getFilename();
                Matcher matcher = changeLogWithVersionPattern.matcher(filename);
                if (!matcher.matches()) continue;
                String fileVersion = matcher.group(1);
                try {
                    Version version = Version.parseVersion(fileVersion);
                    if (maxVersion != null && maxVersion.compareTo(version) >= 0) continue;
                    maxVersion = version;
                }
                catch (IllegalArgumentException iae) {
                    LogFactory.getLogger().warning(String.format("Bad format version found in file: %s/%s. Ignoring this file when computing the max schema version.", changeLogPath, filename));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("could not get changelog files", e);
        }
        if (maxVersion != null) {
            this.maxChangeLogFileVersion = maxVersion;
        }
    }

    public Version getMaxChangeLogFileVersion() {
        return this.maxChangeLogFileVersion;
    }

    public class SpringResourceOpener
    implements ResourceAccessor {
        private String parentFile;

        public SpringResourceOpener(String parentFile) {
            this.parentFile = parentFile;
        }

        public InputStream getResourceAsStream(String file) throws IOException {
            try {
                Resource resource = this.getResource(file);
                return resource.getInputStream();
            }
            catch (FileNotFoundException ex) {
                return null;
            }
        }

        public Enumeration<URL> getResources(String packageName) throws IOException {
            Vector<URL> tmp = new Vector<URL>();
            tmp.add(this.getResource(packageName).getURL());
            return tmp.elements();
        }

        public Resource getResource(String file) {
            return Liquibase.this.getResourceLoader().getResource(this.adjustClasspath(file));
        }

        private String adjustClasspath(String file) {
            return this.isClasspathPrefixPresent(this.parentFile) && !this.isClasspathPrefixPresent(file) ? "classpath:" + file : file;
        }

        public boolean isClasspathPrefixPresent(String file) {
            return file.startsWith("classpath:");
        }

        public ClassLoader toClassLoader() {
            return Liquibase.this.getResourceLoader().getClassLoader();
        }
    }
}

