/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.text;

import com.ibm.icu.text.Bidi;
import org.eclipse.birt.report.engine.layout.pdf.ISplitter;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;

public class BidiSplitter
implements ISplitter {
    private char[] chunkText = null;
    private Bidi bidi = null;
    private int baseLevel;
    private int currentRun = 0;
    private int beginIndex = 0;
    private int endIndex = 0;

    public BidiSplitter(Chunk inputChunk) {
        this.chunkText = inputChunk.getText().toCharArray();
        this.baseLevel = inputChunk.getBaseLevel();
        this.bidi = this.createBidi(inputChunk.getText(), this.baseLevel);
    }

    private Bidi createBidi(String text, int baseLevel) {
        return new Bidi(text, baseLevel);
    }

    private Chunk buildChunk() {
        if (this.currentRun < this.bidi.getRunCount()) {
            this.endIndex = this.bidi.getRunLimit(this.currentRun);
            String text = new String(this.chunkText, this.beginIndex, this.endIndex - this.beginIndex);
            Chunk c = new Chunk(text, this.beginIndex, this.baseLevel, this.bidi.getRunLevel(this.currentRun));
            this.beginIndex = this.endIndex;
            ++this.currentRun;
            return c;
        }
        return null;
    }

    @Override
    public boolean hasMore() {
        return this.currentRun < this.bidi.getRunCount();
    }

    @Override
    public Chunk getNext() {
        return this.buildChunk();
    }
}

